/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.appcfg;

import com.google.appengine.SdkResolver;
import com.google.appengine.tools.admin.AppCfg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractAppCfgMojo
extends AbstractMojo {
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;
    protected String server;
    protected String email;
    protected String host;
    protected String proxyHost;
    protected String proxyHttps;
    protected boolean noCookies;
    protected boolean passin;
    protected boolean insecure;
    protected String appId;
    protected String version;
    protected boolean oauth2;
    protected boolean useJava6;
    protected boolean enableJarSplitting;
    protected String jarSplittingExcludes;
    protected boolean retainUploadDir;
    protected boolean compileEncoding;
    protected Integer numDays;
    protected String severity;
    protected boolean append;
    protected Integer numRuns;
    protected boolean force;
    protected String backendName;
    protected boolean deleteJsps;
    protected boolean enableJarClasses;
    protected MavenProject project;

    protected void executeAppCfgCommand(String action, String appDir) throws MojoExecutionException {
        ArrayList<String> arguments = this.collectParameters();
        arguments.add(action);
        arguments.add(appDir);
        try {
            AppCfg.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error executing appcfg command=" + arguments, ex);
        }
    }

    protected void executeAppCfgBackendsCommand(String action, String appDir) throws MojoExecutionException {
        ArrayList<String> arguments = this.collectParameters();
        arguments.add("backends");
        arguments.add(action);
        arguments.add(appDir);
        arguments.add(this.backendName);
        try {
            AppCfg.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error executing appcfg command=" + arguments, ex);
        }
    }

    private ArrayList<String> collectParameters() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.server != null && !this.server.isEmpty()) {
            arguments.add("-s");
            arguments.add(this.server);
        }
        if (this.email != null && !this.email.isEmpty()) {
            arguments.add("-e");
            arguments.add(this.email);
        }
        if (this.host != null && !this.host.isEmpty()) {
            arguments.add("-H");
            arguments.add(this.host);
        }
        if (this.proxyHost != null && !this.proxyHost.isEmpty()) {
            arguments.add("--proxy");
            arguments.add(this.proxyHost);
        }
        if (this.proxyHttps != null && !this.proxyHttps.isEmpty()) {
            arguments.add("--proxy_https");
            arguments.add(this.proxyHttps);
        }
        if (this.noCookies) {
            arguments.add("--no_cookies");
        }
        if (this.passin) {
            arguments.add("--passin");
        }
        if (this.insecure) {
            arguments.add("--insecure");
        }
        if (this.appId != null && !this.appId.isEmpty()) {
            arguments.add("-A");
            arguments.add(this.appId);
        }
        if (this.version != null && !this.version.isEmpty()) {
            arguments.add("-V");
            arguments.add(this.version);
        }
        if (this.oauth2) {
            arguments.add("--oauth2");
        }
        if (this.useJava6) {
            arguments.add("--use_java6");
        }
        if (this.enableJarSplitting) {
            arguments.add("--enable_jar_splitting");
        }
        if (this.jarSplittingExcludes != null && !this.jarSplittingExcludes.isEmpty()) {
            arguments.add("--jar_splitting_excludes");
            arguments.add(this.jarSplittingExcludes);
        }
        if (this.retainUploadDir) {
            arguments.add("--retain_upload_dir");
        }
        if (this.compileEncoding) {
            arguments.add("--compile_encoding");
        }
        if (this.numDays != null) {
            arguments.add("--num_days");
            arguments.add(this.numDays.toString());
        }
        if (this.severity != null && !this.severity.isEmpty()) {
            arguments.add("--severity");
            arguments.add(this.severity);
        }
        if (this.append) {
            arguments.add("-a");
        }
        if (this.numRuns != null) {
            arguments.add("--num_runs");
            arguments.add(this.numRuns.toString());
        }
        if (this.force) {
            arguments.add("-f");
        }
        if (this.deleteJsps) {
            arguments.add("--delete_jsps");
        }
        if (this.enableJarClasses) {
            arguments.add("--enable_jar_classes");
        }
        return arguments;
    }

    protected void resolveAndSetSdkRoot() throws MojoExecutionException {
        File sdkBaseDir = SdkResolver.getSdk(this.project, this.repoSystem, this.repoSession, this.pluginRepos, this.projectRepos);
        try {
            System.setProperty("appengine.sdk.root", sdkBaseDir.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open SDK zip archive.", (Exception)e);
        }
    }
}

