/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.appengine.endpoints.EndpointsMojo;
import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class EndpointsGetClientLib
extends EndpointsMojo {
    @Override
    protected ArrayList<String> collectParameters(String command) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        this.handleClassPath(arguments);
        if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
            arguments.add("-o");
            arguments.add(this.outputDirectory + "/WEB-INF");
            new File(this.outputDirectory).mkdirs();
        }
        arguments.add("-w");
        arguments.add(this.outputDirectory);
        arguments.add("-l");
        arguments.add("java");
        return arguments;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Google App Engine Java SDK - Generate endpoints get client lib");
        String appDir = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName();
        List<String> classNames = this.getAPIServicesClasses();
        if (classNames.isEmpty()) {
            this.getLog().info((CharSequence)"No Endpoints classes detected.");
            return;
        }
        try {
            this.executeEndpointsCommand("get-client-lib", classNames.toArray(new String[classNames.size()]));
            File webInf = new File(appDir + "/WEB-INF");
            if (webInf.exists() && webInf.isDirectory()) {
                File[] files;
                for (File source : files = webInf.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("-java.zip");
                    }
                })) {
                    File target = new File(this.project.getBasedir(), source.getName());
                    target.delete();
                    Files.move((File)source, (File)target);
                    this.getLog().info((CharSequence)("Endpoint library available at:" + target.getAbsolutePath()));
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while generating Google App Engine endpoint get client lib", e);
        }
        this.getLog().info((CharSequence)"Endpoint get client lib generation done.");
    }
}

