/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.api.server.spi.tools.EndpointsTool;
import com.google.appengine.endpoints.EndpointsMojo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class EndpointsGetDiscoveryDoc
extends EndpointsMojo {
    @Override
    protected ArrayList<String> collectParameters(String command) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        this.handleClassPath(arguments);
        if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
            arguments.add("-o");
            arguments.add(this.outputDirectory + "/WEB-INF");
            new File(this.outputDirectory).mkdirs();
        }
        arguments.add("-w");
        arguments.add(this.outputDirectory);
        return arguments;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Google App Engine Java SDK - Generate endpoints api config...");
        List<String> classNames = this.getAPIServicesClasses();
        if (classNames.isEmpty()) {
            this.getLog().info((CharSequence)"No Endpoints classes detected.");
            return;
        }
        this.executeEndpointsCommand("gen-api-config", classNames.toArray(new String[classNames.size()]));
        File webInf = new File(this.outputDirectory + "/WEB-INF");
        if (webInf.exists() && webInf.isDirectory()) {
            File[] files;
            for (File f : files = webInf.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("api");
                }
            })) {
                this.genDiscoveryDoc("rest", f.getAbsolutePath());
                this.genDiscoveryDoc("rpc", f.getAbsolutePath());
            }
        }
    }

    private void genDiscoveryDoc(String format, String apiConfigFile) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Google App Engine Java SDK - Generate endpoints " + format + " discovery doc for apiConfigFile=" + apiConfigFile));
        try {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("gen-discovery-doc");
            arguments.add("-f");
            arguments.add(format);
            if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
                arguments.add("-o");
                arguments.add(this.outputDirectory + "/WEB-INF");
            }
            arguments.add(apiConfigFile);
            EndpointsTool.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while generating Google App Engine endpoint discovery doc", e);
        }
        this.getLog().info((CharSequence)"Endpoint discovery doc generation done.");
    }
}

