/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.api.server.spi.tools.EndpointsTool;
import com.google.appengine.endpoints.WebXmlProcessing;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class EndpointsMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String classes;
    protected String outputDirectory;
    private String webXmlSourcePath;

    protected void handleClassPath(ArrayList<String> arguments) {
        Iterable jars = Iterables.transform((Iterable)Iterables.filter((Iterable)this.project.getArtifacts(), (Predicate)new Predicate<Artifact>(){

            public boolean apply(Artifact artifact) {
                return artifact.getScope().equals("compile");
            }
        }), (Function)new Function<Artifact, File>(){

            public File apply(Artifact artifact) {
                return artifact.getFile();
            }
        });
        String cp = Joiner.on((String)System.getProperty("path.separator")).join(jars);
        arguments.add("-cp");
        arguments.add(this.project.getBuild().getOutputDirectory() + System.getProperty("path.separator") + this.classes + System.getProperty("path.separator") + cp);
    }

    protected abstract ArrayList<String> collectParameters(String var1);

    protected void executeEndpointsCommand(String action, String[] lastParam) throws MojoExecutionException {
        ArrayList<String> arguments = this.collectParameters(action);
        for (String param : lastParam) {
            arguments.add(param);
            this.getLog().info((CharSequence)("Using Class Name:" + param));
        }
        try {
            this.getLog().info((CharSequence)("Executing endpoints Command=" + arguments));
            EndpointsTool.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Error executing endpoints command=" + arguments, ex);
        }
    }

    protected List<String> getAPIServicesClasses() {
        return new WebXmlProcessing(this.getLog(), this.webXmlSourcePath, this.outputDirectory, this.project).getAPIServicesClasses();
    }
}

