/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.devappserver;

import com.google.appengine.SdkResolver;
import com.google.appengine.repackaged.com.google.api.client.util.Throwables;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractDevAppServerMojo
extends AbstractMojo {
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;
    protected MavenProject project;
    protected String server;
    protected String address;
    protected Integer port;
    protected boolean disableUpdateCheck;
    protected List<String> jvmFlags;
    private boolean offline;
    protected Integer fullScanSeconds;

    protected ArrayList<String> getDevAppServerCommand(String appDir) throws MojoExecutionException {
        boolean isVM;
        this.getLog().info((CharSequence)"Retrieving Google App Engine Java SDK from Maven");
        File sdkBaseDir = SdkResolver.getSdk(this.project, this.repoSystem, this.repoSession, this.pluginRepos, this.projectRepos);
        String javaExecutable = this.joinOnFileSeparator(System.getProperty("java.home"), "bin", "java");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        devAppServerCommand.add(javaExecutable);
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            devAppServerCommand.add("-XstartOnFirstThread");
        }
        if (!(isVM = this.isVMRuntime())) {
            String appengineAgentJar = new File(sdkBaseDir, this.joinOnFileSeparator("lib", "agent", "appengine-agent.jar")).getAbsolutePath();
            devAppServerCommand.add("-javaagent:" + appengineAgentJar);
        } else {
            devAppServerCommand.add("-D--enable_all_permissions=true");
        }
        String appengineDevJdkOverridesJar = new File(sdkBaseDir, this.joinOnFileSeparator("lib", "override", "appengine-dev-jdk-overrides.jar")).getAbsolutePath();
        devAppServerCommand.add("-Xbootclasspath/p:" + appengineDevJdkOverridesJar);
        if (this.fullScanSeconds != null) {
            devAppServerCommand.add("-Dappengine.fullscan.seconds=" + this.fullScanSeconds);
        }
        String appengineToolsApiJar = new File(sdkBaseDir, this.joinOnFileSeparator("lib", "appengine-tools-api.jar")).getAbsolutePath();
        devAppServerCommand.add("-classpath");
        devAppServerCommand.add(appengineToolsApiJar);
        if (this.jvmFlags != null && !this.jvmFlags.isEmpty()) {
            devAppServerCommand.addAll(this.jvmFlags);
        }
        devAppServerCommand.add(DevAppServerMain.class.getCanonicalName());
        devAppServerCommand.add("--allow_remote_shutdown");
        if (isVM) {
            devAppServerCommand.add("--no_java_agent");
        }
        if (this.server != null) {
            devAppServerCommand.add("-s");
            devAppServerCommand.add(this.server);
        }
        if (this.address != null) {
            devAppServerCommand.add("-a");
            devAppServerCommand.add(this.address);
        }
        if (this.port != null) {
            devAppServerCommand.add("-p");
            devAppServerCommand.add(String.valueOf(this.port));
        }
        if (this.disableUpdateCheck || this.offline) {
            devAppServerCommand.add("--disable_update_check");
        }
        devAppServerCommand.add(appDir);
        return devAppServerCommand;
    }

    protected void stopDevAppServer() throws MojoExecutionException {
        HttpURLConnection connection = null;
        try {
            Integer port = (Integer)Objects.firstNonNull((Object)this.port, (Object)8080);
            URL url = new URL("http", (String)Objects.firstNonNull((Object)this.address, (Object)"localhost"), port, "/_ah/admin/quit");
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.getOutputStream().write(0);
            ByteStreams.toByteArray((InputStream)connection.getInputStream());
            connection.disconnect();
            this.getLog().warn((CharSequence)("Shutting down devappserver on port " + port));
            Thread.sleep(2000L);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("URL malformed attempting to stop the devserver : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Was not able to contact the devappserver to shut it down.  Most likely this is due to it simply not running anymore. ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    protected void startDevAppServer(File appDirFile, ArrayList<String> devAppServerCommand, WaitDirective waitDirective) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running " + Joiner.on((String)" ").join(devAppServerCommand)));
        Thread stdOutThread = null;
        Thread stdErrThread = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(devAppServerCommand);
            processBuilder.directory(appDirFile);
            processBuilder.redirectErrorStream(true);
            this.stopDevAppServer();
            final Process devServerProcess = processBuilder.start();
            final CountDownLatch waitStartedLatch = new CountDownLatch(1);
            final Scanner stdOut = new Scanner(devServerProcess.getInputStream());
            stdOutThread = new Thread("standard-out-redirection-devappserver"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (stdOut.hasNextLine() && !Thread.interrupted()) {
                            String line = stdOut.nextLine();
                            AbstractDevAppServerMojo.this.getLog().info((CharSequence)line);
                            if (!line.contains("Dev App Server is now running")) continue;
                            waitStartedLatch.countDown();
                        }
                    }
                    finally {
                        waitStartedLatch.countDown();
                    }
                }
            };
            stdOutThread.setDaemon(true);
            stdOutThread.start();
            final Scanner stdErr = new Scanner(devServerProcess.getErrorStream());
            stdErrThread = new Thread("standard-err-redirection-devappserver"){

                @Override
                public void run() {
                    while (stdErr.hasNextLine() && !Thread.interrupted()) {
                        AbstractDevAppServerMojo.this.getLog().error((CharSequence)stdErr.nextLine());
                    }
                }
            };
            stdErrThread.setDaemon(true);
            stdErrThread.start();
            if (waitDirective == WaitDirective.WAIT_SERVER_STOPPED) {
                Runtime.getRuntime().addShutdownHook(new Thread("destroy-devappserver"){

                    @Override
                    public void run() {
                        if (devServerProcess != null) {
                            devServerProcess.destroy();
                        }
                    }
                });
                devServerProcess.waitFor();
            } else if (waitDirective == WaitDirective.WAIT_SERVER_STARTED) {
                waitStartedLatch.await();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not start the dev app server", (Exception)e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private String joinOnFileSeparator(String ... pathComponents) {
        return Joiner.on((String)File.separator).join((Iterable)ImmutableList.copyOf((Object[])pathComponents));
    }

    private boolean isVMRuntime() {
        String appDir = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName();
        File f = new File(appDir, "WEB-INF/appengine-web.xml");
        if (!f.exists()) {
            return false;
        }
        AppEngineWebXmlReader aewebReader = new AppEngineWebXmlReader(appDir);
        AppEngineWebXml appEngineWebXml = aewebReader.readAppEngineWebXml();
        return appEngineWebXml.getUseVm();
    }

    protected static enum WaitDirective {
        WAIT_SERVER_STARTED,
        WAIT_SERVER_STOPPED;

    }
}

