/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.appengine.endpoints.EndpointsMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class EndpointsGetClientLib
extends EndpointsMojo {
    protected String clientLibsDirectory;

    @Override
    protected ArrayList<String> collectParameters(String command) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        this.handleClassPath(arguments);
        if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
            arguments.add("-o");
            arguments.add(this.outputDirectory + "/WEB-INF");
            arguments.add("-O");
            arguments.add(this.outputDirectory + "/WEB-INF");
            new File(this.outputDirectory).mkdirs();
        }
        arguments.add("-w");
        arguments.add(this.outputDirectory);
        arguments.add("-l");
        arguments.add("java");
        arguments.add("-bs");
        arguments.add("maven");
        return arguments;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Google App Engine Java SDK - Generate endpoints get client lib");
        List<String> classNames = this.getAPIServicesClasses();
        if (classNames.isEmpty()) {
            this.getLog().info((CharSequence)"No Endpoints classes detected.");
            return;
        }
        try {
            this.executeEndpointsCommand("get-client-lib", classNames.toArray(new String[classNames.size()]));
            File webInf = new File(this.outputDirectory + "/WEB-INF");
            if (webInf.exists() && webInf.isDirectory()) {
                File[] files = webInf.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("-java.zip");
                    }
                });
                File mavenProjectsDir = new File(this.clientLibsDirectory);
                mavenProjectsDir.mkdirs();
                for (File source : files) {
                    this.unjar(source, mavenProjectsDir);
                }
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while generating Google App Engine endpoint get client lib", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)("Endpoint get client lib generation done. See the maven projects under:" + this.clientLibsDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unjar(File jar, File destdir) {
        JarFile jarfile;
        try {
            jarfile = new JarFile(jar);
        }
        catch (IOException ex) {
            Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        Enumeration<JarEntry> enu = jarfile.entries();
        while (enu.hasMoreElements()) {
            InputStream is = null;
            try {
                JarEntry je = enu.nextElement();
                File fl = new File(destdir, je.getName());
                if (!fl.exists()) {
                    fl.getParentFile().mkdirs();
                    fl = new File(destdir, je.getName());
                }
                if (je.isDirectory()) continue;
                is = jarfile.getInputStream(je);
                FileOutputStream fo = new FileOutputStream(fl);
                while (is.available() > 0) {
                    fo.write(is.read());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

