/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.appcfg;

import com.google.appengine.SdkResolver;
import com.google.appengine.tools.admin.AppCfg;
import com.google.appengine.tools.admin.Application;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.EarHelper;
import com.google.apphosting.utils.config.EarInfo;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractAppCfgMojo
extends AbstractMojo {
    private static final String USER_AGENT_KEY = "appengine.useragent";
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;
    protected String server;
    protected String email;
    protected String host;
    protected String proxyHost;
    protected String proxyHttps;
    protected boolean noCookies;
    protected boolean passin;
    protected boolean insecure;
    protected String appId;
    protected String version;
    protected boolean oauth2;
    protected boolean enableJarSplitting;
    protected String jarSplittingExcludes;
    protected boolean retainUploadDir;
    protected boolean compileEncoding;
    protected Integer numDays;
    protected String severity;
    protected boolean append;
    protected Integer numRuns;
    protected boolean force;
    protected String backendName;
    protected boolean deleteJsps;
    protected boolean enableJarClasses;
    protected MavenProject project;
    protected String instance;
    protected String[] additionalParams;

    protected void executeAppCfgCommand(String action, String appDir) throws MojoExecutionException {
        ArrayList<String> arguments = this.collectParameters();
        arguments.add(action);
        arguments.add(appDir);
        this.getLog().info((CharSequence)("Running " + Joiner.on((String)" ").join(arguments)));
        try {
            AppCfg.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error executing appcfg command=" + arguments, ex);
        }
    }

    protected void executeAppCfgBackendsCommand(String action, String appDir) throws MojoExecutionException {
        ArrayList<String> arguments = this.collectParameters();
        arguments.add("backends");
        arguments.add(action);
        arguments.add(appDir);
        arguments.add(this.backendName);
        try {
            AppCfg.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error executing appcfg command=" + arguments, ex);
        }
    }

    protected ArrayList<String> collectParameters() throws MojoExecutionException {
        String userDefinedAppId = null;
        String userDefinedVersion = null;
        boolean isEAR = false;
        String appDir = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName();
        File f = new File(appDir, "WEB-INF/appengine-web.xml");
        if (f.exists()) {
            AppEngineWebXmlReader aewebReader = new AppEngineWebXmlReader(appDir);
            AppEngineWebXml appEngineWebXml = aewebReader.readAppEngineWebXml();
            userDefinedAppId = appEngineWebXml.getAppId();
            userDefinedVersion = appEngineWebXml.getMajorVersionId();
        } else if (EarHelper.isEar((String)appDir, (boolean)false)) {
            EarInfo earInfo = EarHelper.readEarInfo((String)appDir, (File)new File(Application.getSdkDocsDir(), "appengine-application.xsd"));
            userDefinedAppId = earInfo.getAppengineApplicationXml().getApplicationId();
            isEAR = true;
        }
        System.setProperty(USER_AGENT_KEY, "appengine-maven-plugin");
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.server != null && !this.server.isEmpty()) {
            arguments.add("-s");
            arguments.add(this.server);
        }
        if (this.email != null && !this.email.isEmpty()) {
            arguments.add("-e");
            arguments.add(this.email);
        }
        if (this.host != null && !this.host.isEmpty()) {
            arguments.add("-H");
            arguments.add(this.host);
        }
        if (this.proxyHost != null && !this.proxyHost.isEmpty()) {
            arguments.add("--proxy=" + this.proxyHost);
        }
        if (this.proxyHttps != null && !this.proxyHttps.isEmpty()) {
            arguments.add("--proxy_https=" + this.proxyHttps);
        }
        if (this.noCookies) {
            arguments.add("--no_cookies");
        }
        if (this.passin) {
            arguments.add("--passin");
        }
        if (this.insecure) {
            arguments.add("--insecure");
        }
        if (this.appId != null && !this.appId.isEmpty()) {
            userDefinedAppId = this.appId;
        }
        if (userDefinedAppId == null) {
            throw new MojoExecutionException("No <application> defined in appengine-web.xml, nor <appId> <configuration> defined in the pom.xml.");
        }
        this.validateAppIdOrVersion(userDefinedAppId);
        arguments.add("-A");
        arguments.add(userDefinedAppId);
        if (this.version != null && !this.version.isEmpty()) {
            userDefinedVersion = this.version;
        }
        if (userDefinedVersion != null) {
            this.validateAppIdOrVersion(userDefinedVersion);
            arguments.add("-V");
            arguments.add(userDefinedVersion);
        } else if (!isEAR) {
            throw new MojoExecutionException("No <version> defined in appengine-web.xml, nor <version> <configuration> defined in the pom.xml.");
        }
        if (this.oauth2) {
            arguments.add("--oauth2");
        }
        if (this.enableJarSplitting) {
            arguments.add("--enable_jar_splitting");
        }
        if (this.jarSplittingExcludes != null && !this.jarSplittingExcludes.isEmpty()) {
            arguments.add("--jar_splitting_excludes=" + this.jarSplittingExcludes);
        }
        if (this.retainUploadDir) {
            arguments.add("--retain_upload_dir");
        }
        if (this.compileEncoding) {
            arguments.add("--compile_encoding");
        }
        if (this.numDays != null) {
            arguments.add("--num_days=" + this.numDays.toString());
        }
        if (this.severity != null && !this.severity.isEmpty()) {
            arguments.add("--severity=" + this.severity);
        }
        if (this.append) {
            arguments.add("-a");
        }
        if (this.numRuns != null) {
            arguments.add("--num_runs=" + this.numRuns.toString());
        }
        if (this.force) {
            arguments.add("-f");
        }
        if (this.deleteJsps) {
            arguments.add("--delete_jsps");
        }
        if (this.enableJarClasses) {
            arguments.add("--enable_jar_classes");
        }
        if (this.additionalParams != null) {
            for (String param : this.additionalParams) {
                if (param == null || param.isEmpty()) continue;
                arguments.add(param);
            }
        }
        return arguments;
    }

    private void validateAppIdOrVersion(String value) throws MojoExecutionException {
        boolean hasUppercase;
        boolean bl = hasUppercase = !value.equals(value.toLowerCase());
        if (hasUppercase) {
            throw new MojoExecutionException("\nError: App Engine Application Id or version cannot contain uppercase: " + value);
        }
        if (!value.contains(":") && value.contains(".")) {
            throw new MojoExecutionException("\nError: App Engine Application Id or version cannot contain dot: " + value);
        }
    }

    protected void resolveAndSetSdkRoot() throws MojoExecutionException {
        File sdkBaseDir = SdkResolver.getSdk(this.project, this.repoSystem, this.repoSession, this.pluginRepos, this.projectRepos);
        try {
            System.setProperty("appengine.sdk.root", sdkBaseDir.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open SDK zip archive.", (Exception)e);
        }
    }
}

