/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.appengine.endpoints.EndpointsMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class EndpointsGetClientLib
extends EndpointsMojo {
    protected String clientLibsDirectory;

    @Override
    protected ArrayList<String> collectParameters(String command) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        this.handleClassPath(arguments);
        if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
            arguments.add("-o");
            arguments.add(this.outputDirectory + "/WEB-INF");
            new File(this.outputDirectory).mkdirs();
        }
        arguments.add("-w");
        arguments.add(this.outputDirectory);
        arguments.add("-l");
        arguments.add("java");
        if (this.buildSystem != null && !this.buildSystem.isEmpty()) {
            arguments.add("-bs");
            arguments.add(this.buildSystem);
        }
        return arguments;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Google App Engine Java SDK - Generate endpoints get client lib");
        List<String> classNames = this.getAPIServicesClasses();
        if (classNames.isEmpty()) {
            this.getLog().info((CharSequence)"No Endpoints classes detected.");
            return;
        }
        try {
            this.executeEndpointsCommand("get-client-lib", new String[0], classNames.toArray(new String[classNames.size()]));
            File webInf = new File(this.outputDirectory + "/WEB-INF");
            if (webInf.exists() && webInf.isDirectory()) {
                File[] files = webInf.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("-java.zip");
                    }
                });
                File mavenProjectsDir = new File(this.clientLibsDirectory);
                mavenProjectsDir.mkdirs();
                for (File source : files) {
                    File pomFile = this.unjarMavenProject(source, mavenProjectsDir);
                    if (pomFile == null) continue;
                    this.getLog().info((CharSequence)("BUILDING Endpoints Client Library from: " + pomFile));
                    DefaultInvocationRequest request = new DefaultInvocationRequest();
                    request.setPomFile(pomFile);
                    request.setGoals(Collections.singletonList("install"));
                    DefaultInvoker invoker = new DefaultInvoker();
                    InvocationResult result = invoker.execute((InvocationRequest)request);
                    if (result.getExitCode() != 0) {
                        throw new IllegalStateException("Build failed.");
                    }
                    this.getLog().info((CharSequence)"Endpoint get client lib generation and compilation done.");
                }
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Error while generating Google App Engine endpoint get client lib", (Exception)((Object)e));
        }
        catch (MavenInvocationException ex) {
            Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unjarMavenProject(File jar, File destdir) {
        JarFile jarfile;
        File pomFile = null;
        try {
            jarfile = new JarFile(jar);
        }
        catch (IOException ex) {
            Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
            return pomFile;
        }
        Enumeration<JarEntry> enu = jarfile.entries();
        while (enu.hasMoreElements()) {
            InputStream is = null;
            try {
                JarEntry je = enu.nextElement();
                File fl = new File(destdir, je.getName());
                if (fl.getName().equals("pom.xml")) {
                    pomFile = fl;
                }
                if (!fl.exists()) {
                    fl.getParentFile().mkdirs();
                    fl = new File(destdir, je.getName());
                }
                if (je.isDirectory()) continue;
                is = jarfile.getInputStream(je);
                FileOutputStream fo = new FileOutputStream(fl);
                while (is.available() > 0) {
                    fo.write(is.read());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(EndpointsGetClientLib.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return pomFile;
    }
}

