/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.endpoints;

import com.google.api.server.spi.config.Api;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.common.base.Joiner;
import eu.infomas.annotation.AnnotationDetector;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebXmlProcessing {
    Log log;
    String webXmlSourcePath;
    String outputDirectory;
    MavenProject project;
    String userSpecifiedServiceClassNames;

    public WebXmlProcessing(Log log, String webXmlSourcePath, String outputDirectory, MavenProject project, String userSpecifiedServiceClassNames) {
        this.log = log;
        this.webXmlSourcePath = webXmlSourcePath;
        this.outputDirectory = outputDirectory;
        this.project = project;
        this.userSpecifiedServiceClassNames = userSpecifiedServiceClassNames;
    }

    private Log getLog() {
        return this.log;
    }

    public List<String> getAPIServicesClasses() {
        List<String> classes;
        if (this.userSpecifiedServiceClassNames != null) {
            classes = Arrays.asList(this.userSpecifiedServiceClassNames.split(","));
        } else {
            ApiReporter reporter = new ApiReporter();
            String targetDir = this.project.getBuild().getOutputDirectory();
            AnnotationDetector cf = new AnnotationDetector((AnnotationDetector.Reporter)reporter);
            try {
                cf.detect(new File[]{new File(targetDir)});
            }
            catch (IOException ex) {
                this.getLog().info((Throwable)ex);
            }
            classes = reporter.getClasses();
        }
        XmlUtil util = new XmlUtil();
        try {
            util.updateWebXml(classes, this.webXmlSourcePath);
        }
        catch (Exception ex) {
            this.getLog().info((CharSequence)("Error: " + ex));
        }
        return classes;
    }

    class XmlUtil {
        private static final String COMMA = ",";
        private static final String WEB_APP = "web-app";
        private static final String INIT_PARAM = "init-param";
        private static final String SERVLET = "servlet";
        private static final String SERVLET_NAME = "servlet-name";
        private static final String SERVLET_MAPPING = "servlet-mapping";
        private static final String SERVLET_CLASS = "servlet-class";
        private static final String URL_PATTERN = "url-pattern";
        private static final String SPI_URL_PATTERN = "/_ah/spi/*";
        private static final String PARAM_NAME = "param-name";
        private static final String PARAM_VALUE = "param-value";
        private static final String SERVICES = "services";
        private static final String SYSTEM_SERVICE_SERVLET = "SystemServiceServlet";
        private static final String SYSTEM_SERVICE_SERVLET_CLASS = "com.google.api.server.spi.SystemServiceServlet";

        XmlUtil() {
        }

        private Node findSystemServiceServlet(Document doc) {
            Node webAppNode;
            for (webAppNode = doc.getFirstChild(); webAppNode != null && !this.isElementAndNamed(webAppNode, WEB_APP); webAppNode = webAppNode.getNextSibling()) {
            }
            if (webAppNode == null) {
                WebXmlProcessing.this.getLog().info((CharSequence)"Not a valid web.xml document");
                return null;
            }
            for (Node systemServiceServletNode = webAppNode.getFirstChild(); systemServiceServletNode != null; systemServiceServletNode = systemServiceServletNode.getNextSibling()) {
                if (!this.isElementAndNamed(systemServiceServletNode, SERVLET)) continue;
                for (Node n3 = systemServiceServletNode.getFirstChild(); n3 != null; n3 = n3.getNextSibling()) {
                    if (!this.isElementAndNamed(n3, SERVLET_NAME) || !n3.getTextContent().equals(SYSTEM_SERVICE_SERVLET)) continue;
                    return systemServiceServletNode;
                }
            }
            return webAppNode;
        }

        private Node insertSystemServiceServlet(Document doc, Node webAppNode, String spc, String delimiter) {
            Node n5 = doc.createTextNode(spc);
            webAppNode.appendChild(n5);
            Element n2 = doc.createElement(SERVLET);
            webAppNode.appendChild(n2);
            n5 = doc.createTextNode(delimiter + spc);
            webAppNode.appendChild(n5);
            Element n3 = doc.createElement(SERVLET_MAPPING);
            webAppNode.appendChild(n3);
            n5 = doc.createTextNode(delimiter);
            webAppNode.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n2.appendChild(n5);
            n5 = doc.createElement(SERVLET_NAME);
            n5.setTextContent(SYSTEM_SERVICE_SERVLET);
            n2.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n2.appendChild(n5);
            n5 = doc.createElement(SERVLET_CLASS);
            n5.setTextContent(SYSTEM_SERVICE_SERVLET_CLASS);
            n2.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n2.appendChild(n5);
            Element n4 = doc.createElement(INIT_PARAM);
            n2.appendChild(n4);
            n5 = doc.createTextNode("\n" + spc);
            n2.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n3.appendChild(n5);
            n5 = doc.createElement(SERVLET_NAME);
            n5.setTextContent(SYSTEM_SERVICE_SERVLET);
            n3.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n3.appendChild(n5);
            n5 = doc.createElement(URL_PATTERN);
            n5.setTextContent(SPI_URL_PATTERN);
            n3.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc);
            n3.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc + spc);
            n4.appendChild(n5);
            n5 = doc.createElement(PARAM_NAME);
            n5.setTextContent(SERVICES);
            n4.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc + spc);
            n4.appendChild(n5);
            n5 = doc.createElement(PARAM_VALUE);
            n5.setTextContent("");
            n4.appendChild(n5);
            n5 = doc.createTextNode("\n" + spc + spc);
            n4.appendChild(n5);
            return n2;
        }

        private boolean isElementAndNamed(Node node, String name) {
            if (node == null || name == null) {
                throw new IllegalArgumentException();
            }
            return node.getNodeType() == 1 && node.getNodeName().equals(name);
        }

        private void saveFile(Document doc, String filePath) throws TransformerFactoryConfigurationError, TransformerException, IOException {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(new File(filePath)));
        }

        private boolean updateSystemServiceServletParam(Document doc, Node systemServiceServletNode, List<String> services) {
            Node paramValueNode;
            Node initParamNode;
            for (initParamNode = systemServiceServletNode.getFirstChild(); initParamNode != null && !this.isElementAndNamed(initParamNode, INIT_PARAM); initParamNode = initParamNode.getNextSibling()) {
            }
            if (initParamNode == null) {
                WebXmlProcessing.this.getLog().info((CharSequence)"Not a valid web.xml document");
                return false;
            }
            for (paramValueNode = initParamNode.getFirstChild(); paramValueNode != null && !this.isElementAndNamed(paramValueNode, PARAM_VALUE); paramValueNode = paramValueNode.getNextSibling()) {
            }
            if (paramValueNode == null) {
                WebXmlProcessing.this.getLog().info((CharSequence)"Not a valid web.xml document");
                return false;
            }
            String serviceXMLString = paramValueNode.getTextContent();
            TreeSet<String> servicesOnFile = new TreeSet<String>();
            if (serviceXMLString != null && !serviceXMLString.trim().isEmpty()) {
                String[] servicesArray;
                for (String s : servicesArray = serviceXMLString.split(COMMA)) {
                    servicesOnFile.add(s.trim());
                }
            }
            ArrayList<String> servicesToRemove = new ArrayList<String>();
            for (String s : servicesOnFile) {
                if (services.contains(s)) continue;
                servicesToRemove.add(s);
            }
            ArrayList<String> servicesToAdd = new ArrayList<String>();
            for (String s : services) {
                if (servicesOnFile.contains(s)) continue;
                servicesToAdd.add(s);
            }
            if (servicesToAdd.isEmpty() && servicesToRemove.isEmpty()) {
                return false;
            }
            for (String s : servicesToRemove) {
                servicesOnFile.remove(s);
            }
            for (String s : servicesToAdd) {
                servicesOnFile.add(s);
            }
            if (servicesOnFile.isEmpty()) {
                paramValueNode.setTextContent("");
            } else {
                Joiner joiner = Joiner.on((String)COMMA);
                paramValueNode.setTextContent(joiner.join(servicesOnFile));
            }
            return true;
        }

        public void updateWebXml(List<String> services, String webXmlPath) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
            String spc = " ";
            String delimiter = "\n";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.parse(webXmlPath);
            Node systemServiceServletNode = this.findSystemServiceServlet(document);
            if (systemServiceServletNode == null) {
                WebXmlProcessing.this.getLog().info((CharSequence)"Not a valid web.xml document");
                return;
            }
            if (this.isElementAndNamed(systemServiceServletNode, WEB_APP)) {
                systemServiceServletNode = this.insertSystemServiceServlet(document, systemServiceServletNode, spc, delimiter);
                boolean bl = true;
            }
            boolean saveRequired = this.updateSystemServiceServletParam(document, systemServiceServletNode, services);
            String generatedWebInf = WebXmlProcessing.this.outputDirectory + "/WEB-INF";
            new File(generatedWebInf).mkdirs();
            this.saveFile(document, generatedWebInf + "/web.xml");
            Files.copy((File)new File(new File(webXmlPath).getParentFile(), "appengine-web.xml"), (File)new File(generatedWebInf, "appengine-web.xml"));
        }
    }

    class ApiReporter
    implements AnnotationDetector.TypeReporter {
        private List<String> classes = new ArrayList<String>();

        ApiReporter() {
        }

        public Class<? extends Annotation>[] annotations() {
            return new Class[]{Api.class};
        }

        public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
            this.classes.add(className);
        }

        public List<String> getClasses() {
            return this.classes;
        }
    }
}

