/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;

public class AppengineEnhancerMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    protected MavenSession session;
    protected BuildPluginManager pluginManager;
    private String enhancerApi;
    private static final String DATANUCLEUS_VERSION = "3.2.0-release";
    private static final Dependency JDO_DEPENDENCY = new Dependency(){
        {
            this.setGroupId("org.datanucleus");
            this.setArtifactId("datanucleus-api-jdo");
            this.setVersion(AppengineEnhancerMojo.DATANUCLEUS_VERSION);
        }
    };
    private static final Dependency JPA_DEPENDENCY = new Dependency(){
        {
            this.setGroupId("org.datanucleus");
            this.setArtifactId("datanucleus-api-jpa");
            this.setVersion(AppengineEnhancerMojo.DATANUCLEUS_VERSION);
        }
    };

    public void execute() throws MojoExecutionException {
        if (!this.enhancerApi.equals("JDO") && !this.enhancerApi.equals("JPA")) {
            throw new MojoExecutionException("enhancerApi must be either JPA or JDO");
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.datanucleus");
        plugin.setArtifactId("datanucleus-maven-plugin");
        plugin.setVersion(DATANUCLEUS_VERSION);
        plugin.addDependency(this.enhancerApi.equals("JDO") ? JDO_DEPENDENCY : JPA_DEPENDENCY);
        for (Dependency transitiveDep : this.mavenProject.getDependencies()) {
            plugin.addDependency(transitiveDep);
        }
        PluginDescriptor pluginDescriptor = null;
        try {
            pluginDescriptor = this.pluginManager.loadPlugin(plugin, this.mavenProject.getRemotePluginRepositories(), this.session.getRepositorySession());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not load the datanucleus plugin.", e);
        }
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo("enhance");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom apiElement = new Xpp3Dom("api");
        apiElement.setValue(this.enhancerApi);
        Xpp3Dom verboseElement = new Xpp3Dom("verbose");
        verboseElement.setValue("true");
        configuration.addChild(apiElement);
        configuration.addChild(verboseElement);
        configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)this.convertPlexusConfiguration(mojoDescriptor.getMojoConfiguration()));
        MojoExecution exec = new MojoExecution(mojoDescriptor, configuration);
        try {
            this.pluginManager.executeMojo(this.session, exec);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not execute datanucleus enhancer.", e);
        }
    }

    private Xpp3Dom convertPlexusConfiguration(PlexusConfiguration config) {
        Xpp3Dom xpp3DomElement = new Xpp3Dom(config.getName());
        xpp3DomElement.setValue(config.getValue());
        for (String string : config.getAttributeNames()) {
            xpp3DomElement.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            xpp3DomElement.addChild(this.convertPlexusConfiguration((PlexusConfiguration)string));
        }
        return xpp3DomElement;
    }
}

