/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractGcloudMojo
extends AbstractMojo {
    protected abstract ArrayList<String> getCommand(String var1) throws MojoExecutionException;

    protected void startCommand(File appDirFile, ArrayList<String> devAppServerCommand, WaitDirective waitDirective) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running " + Joiner.on((String)" ").join(devAppServerCommand)));
        Thread stdOutThread = null;
        Thread stdErrThread = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(devAppServerCommand);
            processBuilder.directory(appDirFile);
            processBuilder.redirectErrorStream(true);
            final Process devServerProcess = processBuilder.start();
            final CountDownLatch waitStartedLatch = new CountDownLatch(1);
            final Scanner stdOut = new Scanner(devServerProcess.getInputStream());
            stdOutThread = new Thread("standard-out-redirection-devappserver"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (stdOut.hasNextLine() && !Thread.interrupted()) {
                            String line = stdOut.nextLine();
                            AbstractGcloudMojo.this.getLog().info((CharSequence)line);
                            if (!line.contains("Starting new HTTP connection")) continue;
                            waitStartedLatch.countDown();
                        }
                    }
                    finally {
                        waitStartedLatch.countDown();
                    }
                }
            };
            stdOutThread.setDaemon(true);
            stdOutThread.start();
            final Scanner stdErr = new Scanner(devServerProcess.getErrorStream());
            stdErrThread = new Thread("standard-err-redirection-devappserver"){

                @Override
                public void run() {
                    while (stdErr.hasNextLine() && !Thread.interrupted()) {
                        AbstractGcloudMojo.this.getLog().error((CharSequence)stdErr.nextLine());
                    }
                }
            };
            stdErrThread.setDaemon(true);
            stdErrThread.start();
            if (waitDirective == WaitDirective.WAIT_SERVER_STOPPED) {
                Runtime.getRuntime().addShutdownHook(new Thread("destroy-devappserver"){

                    @Override
                    public void run() {
                        if (devServerProcess != null) {
                            devServerProcess.destroy();
                        }
                    }
                });
                devServerProcess.waitFor();
                int status = devServerProcess.exitValue();
                if (status != 0) {
                    this.getLog().error((CharSequence)("Error: gcloud app run exit code= " + status));
                    throw new MojoExecutionException("Error: gcloud app run exit code= " + status);
                }
            } else if (waitDirective == WaitDirective.WAIT_SERVER_STARTED) {
                waitStartedLatch.await();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not start the dev app server", (Exception)e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    protected static enum WaitDirective {
        WAIT_SERVER_STARTED,
        WAIT_SERVER_STOPPED;

    }
}

