/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class GCloudAppDeploy
extends AbstractGcloudMojo {
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;
    protected String server;
    protected String gcloud_directory;
    protected String gcloud_app_docker_host;
    protected String gcloud_app_version;
    protected String gcloud_app_env_vars;
    protected String gcloud_app_server;
    protected boolean gcloud_app_force;
    protected String gcloud_project;
    protected String gcloud_verbosity;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"");
        String appDir = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName();
        File appDirFile = new File(appDir);
        if (!appDirFile.exists()) {
            throw new MojoExecutionException("The application directory does not exist : " + appDir);
        }
        if (!appDirFile.isDirectory()) {
            throw new MojoExecutionException("The application directory is not a directory : " + appDir);
        }
        ArrayList<String> devAppServerCommand = this.getCommand(appDir);
        this.startCommand(appDirFile, devAppServerCommand, AbstractGcloudMojo.WaitDirective.WAIT_SERVER_STOPPED);
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running gcloud app deploy...");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        devAppServerCommand.add("python");
        devAppServerCommand.add("-S");
        if (this.gcloud_directory != null) {
            devAppServerCommand.add(this.gcloud_directory + "/lib/googlecloudsdk/gcloud/gcloud.py");
        } else {
            String gcloud = System.getProperty("user.home") + "/google-cloud-sdk/lib/googlecloudsdk/gcloud/gcloud.py";
            this.getLog().info((CharSequence)("Warning, gcloud_directory was not set, so taking: " + gcloud));
        }
        if (this.gcloud_project != null) {
            devAppServerCommand.add("--project=" + this.gcloud_project);
        }
        if (this.gcloud_verbosity != null) {
            devAppServerCommand.add("--verbosity=" + this.gcloud_verbosity);
        }
        devAppServerCommand.add("preview");
        devAppServerCommand.add("app");
        devAppServerCommand.add("deploy");
        File f = new File(appDir, "WEB-INF/appengine-web.xml");
        if (!f.exists()) {
            File ear = new File(appDir);
            for (File w : ear.listFiles()) {
                if (!new File(w, "WEB-INF/appengine-web.xml").exists()) continue;
                devAppServerCommand.add(w.getAbsolutePath());
            }
        } else {
            devAppServerCommand.add(appDir);
        }
        if (this.gcloud_app_docker_host != null) {
            devAppServerCommand.add("--docker-host=" + this.gcloud_app_docker_host);
        }
        if (this.gcloud_app_version != null) {
            devAppServerCommand.add("--version=" + this.gcloud_app_version);
        }
        if (this.gcloud_app_env_vars != null) {
            devAppServerCommand.add("--env-vars=" + this.gcloud_app_env_vars);
        }
        if (this.gcloud_app_server != null) {
            devAppServerCommand.add("--server=" + this.gcloud_app_server);
        } else if (this.server != null) {
            devAppServerCommand.add("--server=" + this.server);
        }
        if (this.gcloud_app_force) {
            devAppServerCommand.add("--force");
        }
        return devAppServerCommand;
    }
}

