/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.gcloudapp;

import com.google.appengine.gcloudapp.AbstractGcloudMojo;
import com.google.appengine.repackaged.com.google.api.client.util.Throwables;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class GCloudAppRun
extends AbstractGcloudMojo {
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> projectRepos;
    protected List<RemoteRepository> pluginRepos;
    protected String server;
    protected String address;
    protected Integer port;
    protected String gcloud_app_api_host;
    protected String gcloud_directory;
    private List<String> gcloud_modules;
    protected String gcloud_app_host;
    protected Integer gcloud_app_port;
    protected String gcloud_app_admin_host;
    protected Integer gcloud_app_admin_port;
    protected String gcloud_app_storage_path;
    protected String gcloud_app_log_level;
    protected String gcloud_project;
    protected String gcloud_verbosity;
    protected String gcloud_app_docker_host;
    protected boolean gcloud_app_enable_cloud_datastore;
    protected MavenProject project;
    protected String appDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File appDirFile;
        this.getLog().info((CharSequence)"");
        if (this.appDir == null) {
            this.appDir = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName();
        }
        if (!(appDirFile = new File(this.appDir)).exists()) {
            throw new MojoExecutionException("The application directory does not exist : " + this.appDir);
        }
        if (!appDirFile.isDirectory()) {
            throw new MojoExecutionException("The application directory is not a directory : " + this.appDir);
        }
        ArrayList<String> devAppServerCommand = this.getCommand(this.appDir);
        this.startCommand(appDirFile, devAppServerCommand, AbstractGcloudMojo.WaitDirective.WAIT_SERVER_STOPPED);
    }

    @Override
    protected ArrayList<String> getCommand(String appDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Running gcloud app run...");
        ArrayList<String> devAppServerCommand = new ArrayList<String>();
        devAppServerCommand.add("python");
        devAppServerCommand.add("-S");
        if (this.gcloud_directory != null) {
            devAppServerCommand.add(this.gcloud_directory + "/lib/googlecloudsdk/gcloud/gcloud.py");
        } else {
            String gcloud = System.getProperty("user.home") + "/google-cloud-sdk/lib/googlecloudsdk/gcloud/gcloud.py";
            this.getLog().info((CharSequence)("Warning, gcloud_directory was not set, so taking: " + gcloud));
        }
        if (this.gcloud_project != null) {
            devAppServerCommand.add("--project=" + this.gcloud_project);
        }
        if (this.gcloud_verbosity != null) {
            devAppServerCommand.add("--verbosity=" + this.gcloud_verbosity);
        }
        devAppServerCommand.add("preview");
        devAppServerCommand.add("app");
        devAppServerCommand.add("run");
        File f = new File(appDir, "WEB-INF/appengine-web.xml");
        if (!f.exists()) {
            File ear = new File(appDir);
            for (File w : ear.listFiles()) {
                if (!new File(w, "WEB-INF/appengine-web.xml").exists()) continue;
                devAppServerCommand.add(w.getAbsolutePath());
            }
        } else {
            devAppServerCommand.add(appDir);
        }
        if (this.gcloud_modules != null && !this.gcloud_modules.isEmpty()) {
            for (String modDir : this.gcloud_modules) {
                this.getLog().info((CharSequence)("Running gcloud app run with extra module in " + modDir));
                devAppServerCommand.add(modDir);
            }
        }
        if (this.gcloud_app_docker_host != null) {
            devAppServerCommand.add("--docker-host=" + this.gcloud_app_docker_host);
        }
        if (this.gcloud_app_api_host != null) {
            devAppServerCommand.add("--api-host=" + this.gcloud_app_api_host);
        }
        if (this.gcloud_app_enable_cloud_datastore) {
            devAppServerCommand.add("--enable-cloud-datastore");
        }
        if (this.gcloud_app_admin_host != null) {
            devAppServerCommand.add("--admin-host=" + this.gcloud_app_admin_host);
        }
        if (this.gcloud_app_host != null) {
            devAppServerCommand.add("--host=" + this.gcloud_app_host);
        }
        if (this.gcloud_app_log_level != null) {
            devAppServerCommand.add("--log-level=" + this.gcloud_app_log_level);
        }
        if (this.gcloud_app_storage_path != null) {
            devAppServerCommand.add("--storage_path=" + this.gcloud_app_storage_path);
        }
        return devAppServerCommand;
    }

    protected void stopDevAppServer() throws MojoExecutionException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL("http", (String)Objects.firstNonNull((Object)this.address, (Object)"localhost"), 8000, "/quit");
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
            ByteStreams.toByteArray((InputStream)connection.getInputStream());
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
            connection.getInputStream().close();
            connection.disconnect();
            this.getLog().warn((CharSequence)"Shutting down gcloud devappserver on port 8000");
            Thread.sleep(4000L);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("URL malformed attempting to stop the devserver : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Was not able to contact the devappserver to shut it down.  Most likely this is due to it simply not running anymore. ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

