/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.cache;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.AsyncCacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.AsyncLoadingCache;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Futures;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.appengine.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@GoogleInternal
@GwtIncompatible(value="Futures")
final class ShimAsyncCache<K, V>
implements AsyncLoadingCache<K, V> {
    private final LoadingCache<K, Entry<K, V>> cache;
    private final ThreadLocal<Map<K, SettableFuture<V>>> batch;
    private final AsyncCacheLoader<K, V> loader;

    private ShimAsyncCache(LoadingCache<K, Entry<K, V>> cache, ThreadLocal<Map<K, SettableFuture<V>>> batch, AsyncCacheLoader<K, V> loader) {
        this.cache = cache;
        this.batch = batch;
        this.loader = loader;
    }

    @Override
    public ListenableFuture<V> get(K key) {
        return this.cache.getUnchecked(key).getOrLoadFuture();
    }

    @Override
    public ImmutableMap<K, ListenableFuture<V>> getAll(Iterable<? extends K> keys) {
        Preconditions.checkState(this.batch.get() == null, "Cannot call getAll() recursively.");
        this.batch.set(new LinkedHashMap());
        LinkedHashMap<K, ListenableFuture<V>> results = new LinkedHashMap<K, ListenableFuture<V>>();
        for (K key : keys) {
            Entry<K, V> entry = this.cache.getUnchecked(key);
            results.put(key, entry.getOrLoadFuture());
        }
        Map<K, SettableFuture<V>> batched = this.batch.get();
        this.batch.remove();
        if (!batched.isEmpty()) {
            K key;
            ImmutableSet<K> batchedKeys = ImmutableSet.copyOf(batched.keySet());
            Map<K, ListenableFuture<V>> loadedMap = ShimAsyncCache.loadAllNullHostile(this.loader, batchedKeys);
            for (Map.Entry<K, ListenableFuture<V>> entry : loadedMap.entrySet()) {
                key = entry.getKey();
                ListenableFuture<V> future = entry.getValue();
                SettableFuture<V> async = batched.remove(key);
                if (async != null) {
                    async.setFuture(future);
                    if (!future.isDone()) continue;
                    results.put(key, future);
                    continue;
                }
                this.makeEntry(key).addFuture(future);
            }
            for (Map.Entry<K, ListenableFuture<V>> entry : batched.entrySet()) {
                key = entry.getKey();
                SettableFuture async = (SettableFuture)entry.getValue();
                ListenableFuture<V> loaded = ShimAsyncCache.loadNullHostile(this.loader, key);
                async.setFuture(loaded);
                if (!loaded.isDone()) continue;
                results.put(key, loaded);
            }
        }
        return ImmutableMap.copyOf(results);
    }

    private static <K, V> ListenableFuture<V> loadNullHostile(AsyncCacheLoader<K, V> loader, K key) {
        try {
            return ShimAsyncCache.nullHostileFuture(loader.load(key));
        }
        catch (RuntimeException e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    private static <K, V> Map<K, ListenableFuture<V>> loadAllNullHostile(AsyncCacheLoader<K, V> loader, Set<K> keys) {
        try {
            return Maps.transformValues(loader.loadAll(keys), new Function<ListenableFuture<V>, ListenableFuture<V>>(){

                @Override
                public ListenableFuture<V> apply(ListenableFuture<V> arg) {
                    return ShimAsyncCache.nullHostileFuture(arg);
                }
            });
        }
        catch (RuntimeException e) {
            return Maps.toMap(keys, new Function<K, ListenableFuture<V>>(){

                @Override
                public ListenableFuture<V> apply(K key) {
                    return Futures.immediateFailedFuture(e);
                }
            });
        }
    }

    private static <T> ListenableFuture<T> nullHostileFuture(ListenableFuture<T> future) {
        ListenableFuture out = Futures.transform(future, new Function<T, T>(){

            @Override
            public T apply(T value) {
                return Preconditions.checkNotNull(value, "AsyncLoadingCache is null-hostile.");
            }
        });
        return out;
    }

    private Entry<K, V> makeEntry(K key) {
        Entry<K, V> entry = new Entry<K, V>(this.cache, this.loader, this.batch, key);
        Entry<K, V> prev = this.cache.asMap().putIfAbsent(key, entry);
        return prev != null ? prev : entry;
    }

    @Override
    @Nullable
    public V getIfPresent(Object key) {
        Entry entry = (Entry)this.cache.getIfPresent(key);
        return entry != null ? (V)entry.getIfPresent() : null;
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(value);
        Entry<K, V> entry = (Entry<K, V>)this.cache.getIfPresent(key);
        if (entry == null) {
            entry = this.makeEntry(key);
        }
        entry.addFuture(Futures.immediateFuture(value));
    }

    static <K, V> ShimAsyncCache<K, V> from(CacheBuilder<Object, Object> builder, final AsyncCacheLoader<K, V> loader) {
        Preconditions.checkNotNull(loader);
        final ThreadLocal<Map<K, SettableFuture<V>>> batch = new ThreadLocal<Map<K, SettableFuture<V>>>();
        final CacheHolder holder = new CacheHolder();
        holder.cache = builder.build(new CacheLoader<K, Entry<K, V>>(){

            @Override
            public Entry<K, V> load(K key) {
                return new Entry(holder.cache, loader, batch, key);
            }

            @Override
            public ListenableFuture<Entry<K, V>> reload(K key, Entry<K, V> old) {
                old.maybeLoad(LoadWhen.ALWAYS);
                return Futures.immediateFuture(old);
            }
        });
        return new ShimAsyncCache(holder.cache, batch, loader);
    }

    private static class CacheHolder<K, V> {
        LoadingCache<K, Entry<K, V>> cache;

        private CacheHolder() {
        }
    }

    private static class Entry<K, V> {
        final ConcurrentMap<K, Entry<K, V>> cache;
        final AsyncCacheLoader<K, V> loader;
        final ThreadLocal<Map<K, SettableFuture<V>>> batch;
        final K key;
        final AtomicReference<EntryState<V>> state = new AtomicReference<Waiting>(new Waiting(PersistentQueue.empty(), SettableFuture.create()));

        Entry(LoadingCache<K, Entry<K, V>> cache, AsyncCacheLoader<K, V> loader, ThreadLocal<Map<K, SettableFuture<V>>> batch, K key) {
            this.cache = cache.asMap();
            this.loader = loader;
            this.batch = batch;
            this.key = key;
        }

        @Nullable
        V getIfPresent() {
            return this.state.get().getIfPresent();
        }

        ListenableFuture<V> getOrLoadFuture() {
            return this.state.get().getOrLoadFuture();
        }

        void maybeLoad(LoadWhen when) {
            this.state.get().maybeLoad(when);
        }

        void addFuture(ListenableFuture<V> future) {
            this.refreshEntry();
            this.state.get().addFuture(future);
            this.listen(future);
        }

        void refreshEntry() {
            this.cache.replace(this.key, this, this);
        }

        void listen(final ListenableFuture<V> future) {
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    Entry.this.state.get().handleCompletion(future);
                }
            }, MoreExecutors.directExecutor());
        }

        void loadOrBatch(SettableFuture<V> async) {
            this.refreshEntry();
            Map<K, SettableFuture<SettableFuture<V>>> batched = this.batch.get();
            if (batched != null) {
                batched.put(this.key, async);
            } else {
                async.setFuture(ShimAsyncCache.loadNullHostile(this.loader, this.key));
            }
            this.listen(async);
        }

        class Value
        implements EntryState<V> {
            final V value;
            final PersistentQueue<V> futures;

            Value(V value, PersistentQueue<V> futures) {
                this.value = value;
                this.futures = futures;
            }

            @Override
            public ListenableFuture<V> getOrLoadFuture() {
                return Futures.immediateFuture(this.value);
            }

            @Override
            @Nullable
            public V getIfPresent() {
                return this.value;
            }

            @Override
            public void maybeLoad(LoadWhen when) {
                if (when == LoadWhen.ALWAYS) {
                    SettableFuture future = SettableFuture.create();
                    if (Entry.this.state.compareAndSet(this, new Value(this.value, this.futures.add(future)))) {
                        Entry.this.loadOrBatch(future);
                    } else {
                        Entry.this.state.get().maybeLoad(when);
                    }
                }
            }

            @Override
            public void addFuture(ListenableFuture<V> future) {
                if (!Entry.this.state.compareAndSet(this, new Value(this.value, this.futures.add(future)))) {
                    Entry.this.state.get().addFuture(future);
                }
            }

            @Override
            public void handleCompletion(ListenableFuture<V> future) {
                PersistentQueue newFutures;
                Object newValue = this.value;
                boolean successful = false;
                try {
                    newValue = Uninterruptibles.getUninterruptibly(future);
                    successful = true;
                    newFutures = this.futures.retainNewer(future);
                }
                catch (ExecutionException thrown) {
                    newFutures = this.futures.remove(future);
                }
                catch (RuntimeException thrown) {
                    newFutures = this.futures.remove(future);
                }
                if (newFutures.size() == this.futures.size()) {
                    return;
                }
                if (Entry.this.state.compareAndSet(this, new Value(newValue, newFutures))) {
                    if (successful) {
                        Entry.this.refreshEntry();
                    }
                } else {
                    Entry.this.state.get().handleCompletion(future);
                }
            }
        }

        class Waiting
        implements EntryState<V> {
            final PersistentQueue<V> futures;
            final SettableFuture<V> result;

            Waiting(PersistentQueue<V> futures, SettableFuture<V> result) {
                this.futures = futures;
                this.result = result;
            }

            @Override
            public ListenableFuture<V> getOrLoadFuture() {
                this.maybeLoad(LoadWhen.NOT_PENDING_OR_AVAILABLE);
                return Futures.nonCancellationPropagating(this.result);
            }

            @Override
            @Nullable
            public V getIfPresent() {
                return null;
            }

            @Override
            public void maybeLoad(LoadWhen when) {
                if (when == LoadWhen.ALWAYS || this.futures.size() == 0) {
                    SettableFuture future = SettableFuture.create();
                    if (Entry.this.state.compareAndSet(this, new Waiting(this.futures.add(future), this.result))) {
                        Entry.this.loadOrBatch(future);
                    } else {
                        Entry.this.state.get().maybeLoad(when);
                    }
                }
            }

            @Override
            public void addFuture(ListenableFuture<V> future) {
                if (!Entry.this.state.compareAndSet(this, new Waiting(this.futures.add(future), this.result))) {
                    Entry.this.state.get().addFuture(future);
                }
            }

            @Override
            public void handleCompletion(ListenableFuture<V> future) {
                try {
                    Object value = Uninterruptibles.getUninterruptibly(future);
                    if (Entry.this.state.compareAndSet(this, new Value(value, this.futures.retainNewer(future)))) {
                        Entry.this.refreshEntry();
                        this.result.set(value);
                    } else {
                        Entry.this.state.get().handleCompletion(future);
                    }
                }
                catch (ExecutionException thrown) {
                    this.handleFailure(future, thrown.getCause());
                }
                catch (RuntimeException thrown) {
                    this.handleFailure(future, thrown);
                }
            }

            private void handleFailure(ListenableFuture<V> future, Throwable cause) {
                SettableFuture newResult = SettableFuture.create();
                if (Entry.this.state.compareAndSet(this, new Waiting(this.futures.remove(future), newResult))) {
                    this.result.setException(cause);
                } else {
                    Entry.this.state.get().handleCompletion(future);
                }
            }
        }

        static interface EntryState<V> {
            @Nullable
            public V getIfPresent();

            public ListenableFuture<V> getOrLoadFuture();

            public void maybeLoad(LoadWhen var1);

            public void addFuture(ListenableFuture<V> var1);

            public void handleCompletion(ListenableFuture<V> var1);
        }
    }

    private static enum LoadWhen {
        NOT_PENDING_OR_AVAILABLE,
        ALWAYS;

    }

    private static class PersistentQueue<V> {
        final ImmutableList<ListenableFuture<V>> futures;

        PersistentQueue(ImmutableList<ListenableFuture<V>> futures) {
            this.futures = futures;
        }

        @CheckReturnValue
        PersistentQueue<V> add(ListenableFuture<V> future) {
            return new PersistentQueue<V>(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(future)).addAll(this.futures)).build());
        }

        @CheckReturnValue
        PersistentQueue<V> retainNewer(ListenableFuture<V> last) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenableFuture listenableFuture : this.futures) {
                if (listenableFuture == last) {
                    return new PersistentQueue<V>(builder.build());
                }
                builder.add(listenableFuture);
            }
            return this;
        }

        @CheckReturnValue
        PersistentQueue<V> remove(ListenableFuture<V> toRemove) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenableFuture listenableFuture : this.futures) {
                if (listenableFuture.equals(toRemove)) continue;
                builder.add(listenableFuture);
            }
            return new PersistentQueue<V>(builder.build());
        }

        int size() {
            return this.futures.size();
        }

        static <V> PersistentQueue<V> empty() {
            return new PersistentQueue<V>(ImmutableList.of());
        }
    }
}

