/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.AbstractByteHasher;
import com.google.appengine.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

@GoogleInternal
final class MacHashFunction
extends AbstractStreamingHashFunction {
    private final String algorithmName;
    private final Key key;
    private final String toString;
    private final int bits;

    MacHashFunction(String algorithmName, Key key, String toString) {
        this.algorithmName = Preconditions.checkNotNull(algorithmName);
        this.key = Preconditions.checkNotNull(key);
        this.toString = Preconditions.checkNotNull(toString);
        this.bits = MacHashFunction.getMac(algorithmName, key).getMacLength() * 8;
    }

    @Override
    public int bits() {
        return this.bits;
    }

    private static Mac getMac(String algorithmName, Key key) {
        try {
            Mac mac = Mac.getInstance(algorithmName);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Hasher newHasher() {
        return new MacHasher(MacHashFunction.getMac(this.algorithmName, this.key));
    }

    public String toString() {
        return this.toString;
    }

    private static final class MacHasher
    extends AbstractByteHasher {
        private final Mac mac;
        private boolean done;

        private MacHasher(Mac mac) {
            this.mac = mac;
        }

        @Override
        protected void update(byte b) {
            this.checkNotDone();
            this.mac.update(b);
        }

        @Override
        protected void update(byte[] b) {
            this.checkNotDone();
            this.mac.update(b);
        }

        @Override
        protected void update(byte[] b, int off, int len) {
            this.checkNotDone();
            this.mac.update(b, off, len);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot re-use a Hasher after calling hash() on it");
        }

        @Override
        public HashCode hash() {
            this.checkNotDone();
            this.done = true;
            return HashCode.fromBytesNoCopy(this.mac.doFinal());
        }
    }
}

