/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppEngineWebXmlReader {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlReader.class.getName());
    private static final String CONCURRENT_REQUESTS_URL = "http://code.google.com/appengine/docs/java/config/appconfig.html#Using_Concurrent_Requests";
    private static final String DATASTORE_AUTO_IDS_URL = "http://developers.google.com/appengine/docs/java/datastore/entities#Kinds_and_Identifiers";
    private static final String APPCFG_AUTO_IDS_URL = "http://developers.google.com/appengine/docs/java/config/appconfig#auto_id_policy";
    public static final String DEFAULT_RELATIVE_FILENAME = "WEB-INF/appengine-web.xml";
    private final String filename;

    public AppEngineWebXmlReader(String appDir, String relativeFilename) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            String string = String.valueOf(appDir);
            char c = File.separatorChar;
            appDir = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        String string = String.valueOf(appDir);
        String string2 = String.valueOf(relativeFilename);
        this.filename = string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public AppEngineWebXmlReader(String appDir) {
        this(appDir, DEFAULT_RELATIVE_FILENAME);
    }

    public AppEngineWebXml readAppEngineWebXml() {
        AppEngineWebXml appEngineWebXml;
        InputStream is = null;
        try {
            is = this.getInputStream();
            appEngineWebXml = this.processXml(is);
            String string = String.valueOf(this.getFilename());
            logger.info(string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
            if (!appEngineWebXml.getThreadsafeValueProvided()) {
                if (this.allowMissingThreadsafeElement()) {
                    logger.warning("appengine-web.xml does not contain a <threadsafe> element. This will be treated as an error the next time you deploy.\nSee http://code.google.com/appengine/docs/java/config/appconfig.html#Using_Concurrent_Requests for more information.\nYou probably want to enable concurrent requests.");
                } else {
                    throw new AppEngineConfigException("appengine-web.xml does not contain a <threadsafe> element.\nSee http://code.google.com/appengine/docs/java/config/appconfig.html#Using_Concurrent_Requests for more information.\nYou probably want to enable concurrent requests.");
                }
            }
            if ("legacy".equals(appEngineWebXml.getAutoIdPolicy())) {
                logger.warning("You have set the datastore auto id policy to 'legacy'. It is recommended that you select 'default' instead.\nLegacy auto ids are deprecated. You can continue to allocate legacy ids manually using the allocateIds() API functions.\nFor more information see:\nhttp://developers.google.com/appengine/docs/java/config/appconfig#auto_id_policy\nhttp://developers.google.com/appengine/docs/java/datastore/entities#Kinds_and_Identifiers\n");
            }
        }
        catch (Exception e) {
            String string = String.valueOf(this.getFilename());
            String msg = string.length() != 0 ? "Received exception processing ".concat(string) : new String("Received exception processing ");
            logger.log(Level.SEVERE, msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        finally {
            this.close(is);
        }
        return appEngineWebXml;
    }

    protected boolean allowMissingThreadsafeElement() {
        return false;
    }

    public String getFilename() {
        return this.filename;
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new AppEngineConfigException(e);
            }
        }
    }

    protected AppEngineWebXml processXml(InputStream is) {
        return new AppEngineWebXmlProcessor().processXml(is);
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            String string = String.valueOf(new File(this.getFilename()).getAbsolutePath());
            throw new AppEngineConfigException(string.length() != 0 ? "Could not locate ".concat(string) : new String("Could not locate "), fnfe);
        }
    }
}

