/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.cron.GrocTimeSpecification;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.RetryParametersXml;
import java.util.ArrayList;
import java.util.List;

public class CronXml {
    private List<Entry> entries = new ArrayList<Entry>();

    public Entry addNewEntry() {
        this.validateLastEntry();
        Entry entry = new Entry();
        this.entries.add(entry);
        return entry;
    }

    public void addEntry(Entry entry) {
        this.validateLastEntry();
        this.entries.add(entry);
        this.validateLastEntry();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void validateLastEntry() {
        if (this.entries.size() == 0) {
            return;
        }
        Entry last = this.entries.get(this.entries.size() - 1);
        if (last.getUrl() == null) {
            throw new AppEngineConfigException("no URL for cronentry");
        }
        if (last.getSchedule() == null) {
            String string = String.valueOf(last.getUrl());
            throw new AppEngineConfigException(string.length() != 0 ? "no schedule for cronentry ".concat(string) : new String("no schedule for cronentry "));
        }
        try {
            GrocTimeSpecification grocTimeSpecification = GrocTimeSpecification.create((String)last.schedule);
        }
        catch (IllegalArgumentException iae) {
            String string = last.schedule;
            throw new AppEngineConfigException(new StringBuilder(25 + String.valueOf(string).length()).append("schedule ").append(string).append(" failed to parse").toString(), iae.getCause());
        }
    }

    public String toYaml() {
        this.validateLastEntry();
        StringBuilder builder = new StringBuilder("cron:\n");
        for (Entry ent : this.entries) {
            RetryParametersXml retryParameters;
            String string = String.valueOf(ent.getDescription().replace("'", "''"));
            builder.append(new StringBuilder(18 + String.valueOf(string).length()).append("- description: '").append(string).append("'\n").toString());
            string = ent.getUrl();
            builder.append(new StringBuilder(8 + String.valueOf(string).length()).append("  url: ").append(string).append("\n").toString());
            string = ent.getSchedule();
            builder.append(new StringBuilder(13 + String.valueOf(string).length()).append("  schedule: ").append(string).append("\n").toString());
            string = ent.getTimezone();
            builder.append(new StringBuilder(13 + String.valueOf(string).length()).append("  timezone: ").append(string).append("\n").toString());
            String target = ent.getTarget();
            if (target != null) {
                builder.append(new StringBuilder(11 + String.valueOf(target).length()).append("  target: ").append(target).append("\n").toString());
            }
            if ((retryParameters = ent.getRetryParameters()) == null) continue;
            builder.append(retryParameters.toYaml("job"));
        }
        return builder.toString();
    }

    public static class Entry {
        private static final String TZ_GMT = "UTC";
        private String url = null;
        private String desc = "";
        private String tz = "UTC";
        private String schedule = null;
        private String target = null;
        private RetryParametersXml retryParameters = null;

        public void setDescription(String description) {
            this.desc = description.replace('\n', ' ');
        }

        public void setUrl(String url) {
            this.url = url.replace('\n', ' ');
        }

        public void setSchedule(String schedule) {
            this.schedule = schedule = schedule.replace('\n', ' ');
        }

        public void setTimezone(String timezone) {
            this.tz = timezone.replace('\n', ' ');
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setRetryParameters(RetryParametersXml retryParameters) {
            this.retryParameters = retryParameters;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public String getTimezone() {
            return this.tz;
        }

        public String getTarget() {
            return this.target;
        }

        public RetryParametersXml getRetryParameters() {
            return this.retryParameters;
        }
    }
}

