/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.RetryParametersXml;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class CronXmlReader
extends AbstractConfigXmlReader<CronXml> {
    private static final String FILENAME = "WEB-INF/cron.xml";
    private static final String CRONENTRIES_TAG = "cronentries";
    private static final String CRON_TAG = "cron";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String TARGET_TAG = "target";
    private static final String TIMEZONE_TAG = "timezone";
    private static final String URL_TAG = "url";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String JOB_RETRY_LIMIT_TAG = "job-retry-limit";
    private static final String JOB_AGE_LIMIT_TAG = "job-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";

    public CronXmlReader(String appDir) {
        super(appDir, false);
    }

    public CronXml readCronXml() {
        return (CronXml)this.readConfigXml();
    }

    @Override
    protected CronXml processXml(InputStream is) {
        final CronXml cronXml = new CronXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean first = true;
            CronXml.Entry entry;
            boolean insideRetryParametersTag = false;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!CronXmlReader.CRONENTRIES_TAG.equalsIgnoreCase(node.getTag())) {
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length()).append(string).append(" does not contain <").append(CronXmlReader.CRONENTRIES_TAG).append(">").toString());
                        }
                        if (!this.first) {
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(32 + String.valueOf(string).length()).append(string).append(" contains multiple <").append(CronXmlReader.CRONENTRIES_TAG).append(">").toString());
                        }
                        this.first = false;
                        break;
                    }
                    case 1: {
                        if (CronXmlReader.CRON_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry = cronXml.addNewEntry();
                            break;
                        }
                        String string = CronXmlReader.this.getFilename();
                        String string2 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains <").append(string2).append("> instead of <").append(CronXmlReader.CRON_TAG).append("/>").toString());
                    }
                    case 2: {
                        this.insideRetryParametersTag = false;
                        assert (this.entry != null);
                        if (CronXmlReader.DESCRIPTION_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setDescription((String)node.get(0));
                                break;
                            }
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(34 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(CronXmlReader.DESCRIPTION_TAG).append(">").toString());
                        }
                        if (CronXmlReader.URL_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setUrl((String)node.get(0));
                                break;
                            }
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(26 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(CronXmlReader.URL_TAG).append(">").toString());
                        }
                        if (CronXmlReader.SCHEDULE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setSchedule((String)node.get(0));
                                break;
                            }
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(CronXmlReader.SCHEDULE_TAG).append(">").toString());
                        }
                        if (CronXmlReader.TIMEZONE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setTimezone((String)node.get(0));
                                break;
                            }
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(CronXmlReader.TIMEZONE_TAG).append(">").toString());
                        }
                        if (CronXmlReader.TARGET_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setTarget((String)node.get(0));
                                break;
                            }
                            String string = CronXmlReader.this.getFilename();
                            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append(string).append(" has bad contents in <").append(CronXmlReader.TARGET_TAG).append(">").toString());
                        }
                        if (CronXmlReader.RETRY_PARAMETERS_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry.setRetryParameters(new RetryParametersXml());
                            this.insideRetryParametersTag = true;
                            break;
                        }
                        String string = CronXmlReader.this.getFilename();
                        String string3 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" contains unknown <").append(string3).append("> inside <").append(CronXmlReader.CRON_TAG).append("/>").toString());
                    }
                    case 3: {
                        assert (this.insideRetryParametersTag);
                        assert (this.entry != null);
                        boolean brokenTag = node.size() != 1 || !(node.get(0) instanceof String);
                        RetryParametersXml retryParameters = this.entry.getRetryParameters();
                        assert (this.entry.getRetryParameters() != null);
                        if (CronXmlReader.JOB_RETRY_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setRetryLimit(CronXmlReader.this.getString(node));
                            }
                        } else if (CronXmlReader.JOB_AGE_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setAgeLimitSec(CronXmlReader.this.getString(node));
                            }
                        } else if (CronXmlReader.MIN_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMinBackoffSec(CronXmlReader.this.getString(node));
                            }
                        } else if (CronXmlReader.MAX_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMaxBackoffSec(CronXmlReader.this.getString(node));
                            }
                        } else if (CronXmlReader.MAX_DOUBLINGS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMaxDoublings(CronXmlReader.this.getString(node));
                            }
                        } else {
                            String string = CronXmlReader.this.getFilename();
                            String string4 = String.valueOf(node.getTag());
                            throw new AppEngineConfigException(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append(" contains unknown <").append(string4).append("> inside <").append(CronXmlReader.RETRY_PARAMETERS_TAG).append("/>").toString());
                        }
                        if (!brokenTag) break;
                        String string = CronXmlReader.this.getFilename();
                        String string5 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string5).length()).append(string).append(" has bad contents in <").append(string5).append(">").toString());
                    }
                    default: {
                        String string = CronXmlReader.this.getFilename();
                        String string6 = String.valueOf(node.getTag());
                        throw new AppEngineConfigException(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string6).length()).append(string).append(" has a syntax error; node <").append(string6).append("> is too deeply nested to be valid.").toString());
                    }
                }
            }
        }, is);
        cronXml.validateLastEntry();
        return cronXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

