/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.WebModule;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class EarInfo {
    private static final Logger LOGGER = Logger.getLogger(EarInfo.class.getName());
    private final File earDirectory;
    private final AppEngineApplicationXml appEngineApplicationXml;
    private final ApplicationXml applicationXml;
    private final List<WebModule> webModules;
    private final Map<String, WebModule> moduleMap;

    EarInfo(File earDirectory, AppEngineApplicationXml appEngineApplicationXml, ApplicationXml applicationXml, List<WebModule> webModules) throws AppEngineConfigException {
        this.earDirectory = earDirectory;
        this.appEngineApplicationXml = appEngineApplicationXml;
        this.applicationXml = applicationXml;
        this.webModules = ImmutableList.copyOf(webModules.iterator());
        ImmutableMap.Builder<String, WebModule> builder = ImmutableMap.builder();
        for (WebModule webModule : webModules) {
            builder.put(webModule.getModuleName(), webModule);
        }
        try {
            this.moduleMap = builder.build();
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("duplicate key: ")) {
                String msg = "Invalid EAR - Duplicate module name";
                LOGGER.info(msg);
                throw new AppEngineConfigException(msg, iae);
            }
            throw iae;
        }
    }

    public File getEarDirectory() {
        return this.earDirectory;
    }

    public ApplicationXml getApplicationXml() {
        return this.applicationXml;
    }

    public AppEngineApplicationXml getAppengineApplicationXml() {
        return this.appEngineApplicationXml;
    }

    public List<WebModule> getWebModules() {
        return this.webModules;
    }

    WebModule getWebModule(String moduleName) {
        return this.moduleMap.get(moduleName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appEngineApplicationXml == null ? 0 : this.appEngineApplicationXml.hashCode());
        result = 31 * result + (this.applicationXml == null ? 0 : this.applicationXml.hashCode());
        result = 31 * result + (this.earDirectory == null ? 0 : this.earDirectory.hashCode());
        result = 31 * result + (this.webModules == null ? 0 : this.webModules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EarInfo other = (EarInfo)obj;
        if (this.appEngineApplicationXml == null ? other.appEngineApplicationXml != null : !this.appEngineApplicationXml.equals(other.appEngineApplicationXml)) {
            return false;
        }
        if (this.applicationXml == null ? other.applicationXml != null : !this.applicationXml.equals(other.applicationXml)) {
            return false;
        }
        if (this.earDirectory == null ? other.earDirectory != null : !this.earDirectory.equals(other.earDirectory)) {
            return false;
        }
        return !(this.webModules == null ? other.webModules != null : !this.webModules.equals(other.webModules));
    }

    public String toString() {
        String string = String.valueOf(this.earDirectory);
        String string2 = String.valueOf(this.appEngineApplicationXml);
        String string3 = String.valueOf(this.applicationXml);
        String string4 = String.valueOf(this.webModules);
        return new StringBuilder(75 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("EarInfo: earDirectory=").append(string).append(" appEngineApplicationXml=").append(string2).append(" applicationXml=").append(string3).append(" webModules=").append(string4).toString();
    }
}

