/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlReader;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DispatchXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;

public class DispatchYamlReader {
    private static final String DISPATCH_FILENAME = "dispatch.yaml";
    private final String parentDirectory;

    public DispatchYamlReader(String parentDirectory) {
        if (parentDirectory.length() > 0 && parentDirectory.charAt(parentDirectory.length() - 1) != File.separatorChar) {
            String string = String.valueOf(parentDirectory);
            char c = File.separatorChar;
            parentDirectory = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        this.parentDirectory = parentDirectory;
    }

    public String getFilename() {
        String string = String.valueOf(this.parentDirectory);
        String string2 = String.valueOf(DISPATCH_FILENAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public DispatchXml parse() {
        Object result = null;
        try {
            return DispatchYamlReader.parseImpl(new FileReader(this.getFilename()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @VisibleForTesting
    static DispatchXml parseImpl(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(DispatchYaml.class, "dispatch", DispatchYamlEntry.class);
        try {
            DispatchYaml dispatchYaml = reader.read(DispatchYaml.class);
            if (dispatchYaml == null) {
                throw new AppEngineConfigException("Empty dispatch.yaml configuration.");
            }
            return dispatchYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static class DispatchYamlEntry {
        private String url;
        private String module;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }

        DispatchXml.DispatchEntry asDispatchEntry() {
            return new DispatchXml.DispatchEntry(this.url, this.module);
        }
    }

    public static class DispatchYaml {
        private List<DispatchYamlEntry> dispatchEntries;

        public List<DispatchYamlEntry> getDispatch() {
            return this.dispatchEntries;
        }

        public void setDispatch(List<DispatchYamlEntry> entries) {
            this.dispatchEntries = entries;
        }

        public DispatchXml toXml() {
            DispatchXml.Builder builder = DispatchXml.builder();
            if (this.dispatchEntries != null) {
                for (DispatchYamlEntry entry : this.dispatchEntries) {
                    builder.addDispatchEntry(entry.asDispatchEntry());
                }
            }
            return builder.build();
        }
    }
}

