/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.Version;
import com.google.apphosting.utils.config.StagingOptions;
import java.io.File;

public class ApplicationProcessingOptions {
    private static final String JAVA_CMD_PROP = "appengine.java";
    private static final String JAVAC_CMD_PROP = "appengine.javac";
    private File java;
    private File javac;
    private boolean compileJsps = true;
    private boolean doBatch = true;
    private boolean useAsyncQuickstart = false;
    private String runtime;
    private boolean allowAnyRuntime = false;
    private boolean failOnPrecompilationError = false;
    private boolean ignoreEndpointsFailures = true;
    private boolean quickstart = false;
    private boolean callerUploadingDispatch = false;
    private StagingOptions stagingOptions = StagingOptions.EMPTY;
    private StagingOptions defaultStagingOptions = StagingOptions.ANCIENT_DEFAULTS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getJavaExecutable() {
        if (this.java != null) {
            return this.java;
        }
        String javaProp = System.getProperty(JAVA_CMD_PROP);
        if (javaProp != null) {
            this.java = new File(javaProp);
            if (this.java.exists()) return this.java;
            if (!Utility.isOsWindows() || javaProp.endsWith(".exe") || !new File(String.valueOf(javaProp).concat(".exe")).exists()) throw new IllegalStateException(new StringBuilder(30 + String.valueOf(javaProp).length()).append("cannot find java executable \"").append(javaProp).append("\"").toString());
            this.java = new File(String.valueOf(javaProp).concat(".exe"));
            return this.java;
        } else {
            String javaHome = System.getProperty("java.home");
            String string = File.separator;
            String string2 = File.separator;
            String string3 = Utility.isOsWindows() ? ".exe" : "";
            String javaCmd = new StringBuilder(7 + String.valueOf(javaHome).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(javaHome).append(string).append("bin").append(string2).append("java").append(string3).toString();
            this.java = new File(javaCmd);
            if (this.java.exists()) return this.java;
            this.java = null;
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(javaCmd).length()).append("cannot find java executable based on java.home, tried \"").append(javaCmd).append("\"").toString());
        }
    }

    void setJavaExecutable(File java) {
        this.java = java;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getJavaCompiler() {
        if (this.javac != null) {
            return this.javac;
        }
        String javacProp = System.getProperty(JAVAC_CMD_PROP);
        if (javacProp != null) {
            this.javac = new File(javacProp);
            if (this.javac.exists()) return this.javac;
            if (!Utility.isOsWindows() || javacProp.endsWith(".exe") || !new File(String.valueOf(javacProp).concat(".exe")).exists()) throw new IllegalStateException(new StringBuilder(31 + String.valueOf(javacProp).length()).append("cannot find javac executable \"").append(javacProp).append("\"").toString());
            this.javac = new File(String.valueOf(javacProp).concat(".exe"));
            return this.javac;
        } else {
            String javaHome;
            String javacDir;
            String string = javacDir = (javaHome = System.getProperty("java.home"));
            String string2 = File.separator;
            String string3 = File.separator;
            String string4 = Utility.isOsWindows() ? ".exe" : "";
            String javacCmd = new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append("bin").append(string3).append("javac").append(string4).toString();
            this.javac = new File(javacCmd);
            if (this.javac.exists()) return this.javac;
            this.javac = null;
            string2 = javacDir = new File(javaHome).getParentFile().getPath();
            string3 = File.separator;
            string4 = File.separator;
            String string5 = Utility.isOsWindows() ? ".exe" : "";
            String javacCmd2 = new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string2).append(string3).append("bin").append(string4).append("javac").append(string5).toString();
            this.javac = new File(javacCmd2);
            if (this.javac.exists()) return this.javac;
            this.javac = null;
            throw new IllegalStateException(new StringBuilder(64 + String.valueOf(javacCmd).length() + String.valueOf(javacCmd2).length()).append("cannot find javac executable based on java.home, tried \"").append(javacCmd).append("\" and \"").append(javacCmd2).append("\"").toString());
        }
    }

    void setJavaCompiler(File javac) {
        this.javac = javac;
    }

    public boolean isCompileJspsSet() {
        return this.compileJsps;
    }

    void setCompileJsps(boolean doJsps) {
        this.compileJsps = doJsps;
    }

    public boolean isBatchModeSet() {
        return this.doBatch;
    }

    void setBatchMode(boolean doBatch) {
        this.doBatch = doBatch;
    }

    public void setUseAsyncQuickstart(boolean b) {
        this.useAsyncQuickstart = b;
    }

    public boolean isUseAsyncQuickstart() {
        return this.useAsyncQuickstart;
    }

    void setUseJetty9(boolean b) {
        Version.setUseJetty9(b);
        if (b && this.runtime == null) {
            this.runtime = "java8";
        }
    }

    public void setDefaultStagingOptions(StagingOptions opts) {
        this.defaultStagingOptions = opts;
    }

    public StagingOptions getDefaultStagingOptions() {
        return this.defaultStagingOptions;
    }

    public void setStagingOptions(StagingOptions opts) {
        this.stagingOptions = opts;
    }

    public StagingOptions getStagingOptions() {
        return this.stagingOptions;
    }

    public void setRuntime(String s) {
        this.runtime = s;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setAllowAnyRuntime(boolean b) {
        this.allowAnyRuntime = b;
    }

    public boolean isAllowAnyRuntime() {
        return this.allowAnyRuntime;
    }

    public void setFailOnPrecompilationError(boolean b) {
        this.failOnPrecompilationError = b;
    }

    public boolean isFailOnPrecompilationError() {
        return this.failOnPrecompilationError;
    }

    public void setIgnoreEndpointsFailures(boolean b) {
        this.ignoreEndpointsFailures = b;
    }

    public boolean isIgnoreEndpointsFailures() {
        return this.ignoreEndpointsFailures;
    }

    public void setQuickstart(boolean b) {
        this.quickstart = b;
    }

    public boolean isQuickstart() {
        return this.quickstart;
    }

    public void setCallerUploadingDispatch(boolean b) {
        this.callerUploadingDispatch = b;
    }

    boolean isCallerUploadingDispatch() {
        return this.callerUploadingDispatch;
    }
}

