/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ClassLoaderUtil;
import com.google.appengine.tools.info.AppengineSdk;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;

class DevAppServerClassLoader
extends URLClassLoader {
    private final ClassLoader delegate;
    private static final String DEV_APP_SERVER_INTERFACE = "com.google.appengine.tools.development.DevAppServer";
    private static final String APP_CONTEXT_INTERFACE = "com.google.appengine.tools.development.AppContext";
    private static final String DEV_APP_SERVER_AGENT = "com.google.appengine.tools.development.agent.AppEngineDevAgent";
    private static final String DEV_SOCKET_IMPL_FACTORY = "com.google.appengine.tools.development.DevSocketImplFactory";
    static final String SYSTEM_CLASS_PREFIX_PROPERTY = "com.google.appengine.system.class.prefix";

    public static DevAppServerClassLoader newClassLoader(ClassLoader delegate) {
        ArrayList<URL> libs = new ArrayList<URL>(AppengineSdk.getSdk().getSharedLibs());
        libs.addAll(AppengineSdk.getSdk().getImplLibs());
        libs.addAll(AppengineSdk.getSdk().getUserJspLibs());
        return new DevAppServerClassLoader(libs.toArray(new URL[libs.size()]), delegate);
    }

    DevAppServerClassLoader(URL[] urls, ClassLoader delegate) {
        super(urls, ClassLoaderUtil.getPlatformClassLoader());
        this.delegate = delegate;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String systemClassPrefix = System.getProperty(SYSTEM_CLASS_PREFIX_PROPERTY, "///");
        if (name.startsWith(systemClassPrefix)) {
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (name.equals(DEV_APP_SERVER_INTERFACE) || name.equals(APP_CONTEXT_INTERFACE) || name.equals(DEV_APP_SERVER_AGENT) || name.equals(DEV_SOCKET_IMPL_FACTORY) || name.startsWith("com.google.appengine.tools.info.") || name.startsWith("com.google.apphosting.utils.config.")) {
            Class<?> c = this.delegate.loadClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissions = super.getPermissions(codesource);
        permissions.add(new AllPermission());
        return permissions;
    }
}

