/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.development.SharedMain;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DevAppServerMain
extends SharedMain {
    public static final String GENERATE_WAR_ARG = "generate_war";
    public static final String GENERATED_WAR_DIR_ARG = "generated_war_dir";
    private static final String DEFAULT_RDBMS_PROPERTIES_FILE = ".local.rdbms.properties";
    private static final String RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY = "rdbms.properties.file";
    private static final String SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX = "com.google.appengine.devappserver_module.";
    private final Action startAction = new StartAction();
    private String versionCheckServer = AppengineSdk.getSdk().getDefaultServer();
    private String address = "localhost";
    private int port = 8080;
    private boolean disableUpdateCheck;
    private String generatedDirectory = null;
    private String defaultGcsBucketName = null;
    private String applicationId = null;

    @VisibleForTesting
    List<Option> getBuiltInOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.addAll(this.getSharedOptions());
        options.addAll(Arrays.asList(new Option("s", "server", false){

            @Override
            public void apply() {
                DevAppServerMain.this.versionCheckServer = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --server=SERVER            The server to use to determine the latest", "  -s SERVER                   SDK version.");
            }
        }, new Option("a", "address", false){

            @Override
            public void apply() {
                DevAppServerMain.this.address = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --address=ADDRESS          The address of the interface on the local machine", "  -a ADDRESS                  to bind to (or 0.0.0.0 for all interfaces).");
            }
        }, new Option("p", "port", false){

            @Override
            public void apply() {
                DevAppServerMain.this.port = Integer.parseInt(this.getValue());
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --port=PORT                The port number to bind to on the local machine.", "  -p PORT");
            }
        }, new Option(null, "disable_update_check", true){

            @Override
            public void apply() {
                DevAppServerMain.this.disableUpdateCheck = true;
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --disable_update_check     Disable the check for newer SDK versions.");
            }
        }, new Option(null, "generated_dir", false){

            @Override
            public void apply() {
                DevAppServerMain.this.generatedDirectory = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --generated_dir=DIR        Set the directory where generated files are created.");
            }
        }, new Option(null, "default_gcs_bucket", false){

            @Override
            public void apply() {
                DevAppServerMain.this.defaultGcsBucketName = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --default_gcs_bucket=NAME  Set the default Google Cloud Storage bucket name.");
            }
        }, new Option("A", "application", false){

            @Override
            public void apply() {
                DevAppServerMain.this.applicationId = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --application=APP_ID       Set the application, overriding the application ", "  -A APP_ID                   value from the application's configuration files.");
            }
        }, new Option(this, null, "instance_port", false){

            @Override
            public void apply() {
                DevAppServerMain.processInstancePorts(this.getValues());
            }
        }, new Option(this, null, "disable_filesapi_warning", true){

            @Override
            public void apply() {
                System.setProperty("appengine.disableFilesApiWarning", "true");
            }
        }, new Option(this, null, "enable_filesapi", true){

            @Override
            public void apply() {
                System.setProperty("appengine.enableFilesApi", "true");
            }
        }));
        return options;
    }

    private static void processInstancePorts(List<String> optionValues) {
        for (String optionValue : optionValues) {
            String[] keyAndValue = optionValue.split("=", 2);
            if (keyAndValue.length != 2) {
                DevAppServerMain.reportBadInstancePortValue(optionValue);
            }
            try {
                Integer.parseInt(keyAndValue[1]);
            }
            catch (NumberFormatException nfe) {
                DevAppServerMain.reportBadInstancePortValue(optionValue);
            }
            String string = keyAndValue[0].trim();
            System.setProperty(new StringBuilder(46 + String.valueOf(string).length()).append(SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX).append(string).append(".port").toString(), keyAndValue[1].trim());
        }
    }

    private static void reportBadInstancePortValue(String optionValue) {
        String string = String.valueOf(optionValue);
        throw new IllegalArgumentException(string.length() != 0 ? "Invalid instance_port value ".concat(string) : new String("Invalid instance_port value "));
    }

    private List<Option> buildOptions() {
        return this.getBuiltInOptions();
    }

    public static void main(String[] args) throws Exception {
        SharedMain.sharedInit();
        new DevAppServerMain().run(args);
    }

    public void run(String[] args) throws Exception {
        Parser parser = new Parser();
        Parser.ParseResult result = parser.parseArgs(this.startAction, this.buildOptions(), args);
        result.applyArgs();
    }

    @Override
    public void printHelp(PrintStream out) {
        out.println("Usage: <dev-appserver> [options] <app directory> [<appn directory> ...]");
        out.println("");
        out.println("Options:");
        for (Option option : this.buildOptions()) {
            for (String helpString : option.getHelpLines()) {
                out.println(helpString);
            }
        }
        out.println(" --jvm_flag=FLAG            Pass FLAG as a JVM argument. May be repeated to");
        out.println("                              supply multiple flags.");
    }

    public static void recursiveDelete(File dead) {
        File[] files = dead.listFiles();
        if (files != null) {
            for (File name : files) {
                DevAppServerMain.recursiveDelete(name);
            }
        }
        dead.delete();
    }

    @VisibleForTesting
    File constructTemporaryEARDirectory(List<String> services) throws IOException {
        final File path = Files.createTempDirectory("tmpEarArea", new FileAttribute[0]).toFile();
        Runtime.getRuntime().addShutdownHook(new Thread(this){

            @Override
            public void run() {
                DevAppServerMain.recursiveDelete(path);
            }
        });
        File metaInf = new File(path, "META-INF");
        metaInf.mkdir();
        try (BufferedWriter fw = Files.newBufferedWriter(new File(metaInf, "application.xml").toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write("<application ");
            fw.write("xmlns=\"http://java.sun.com/xml/ns/javaee\" ");
            fw.write("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            fw.write("xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee ");
            fw.write("http://java.sun.com/xml/ns/javaee/application_5.xsd\" ");
            fw.write("version=\"5\">");
            fw.write("<display-name>appengine-modules-ear</display-name>");
            TreeSet<String> contextRootNames = new TreeSet<String>();
            for (String service : services) {
                String string;
                File serviceFile = new File(service);
                fw.write("<module>");
                fw.write("<web>");
                String string2 = String.valueOf(serviceFile.toURI());
                fw.write(new StringBuilder(19 + String.valueOf(string2).length()).append("<web-uri>").append(string2).append("</web-uri>").toString());
                String contextRoot = serviceFile.getName();
                int index = 0;
                while (contextRootNames.contains(contextRoot)) {
                    string = String.valueOf(contextRoot);
                    int n = index++;
                    contextRoot = new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString();
                }
                contextRootNames.add(contextRoot);
                string = contextRoot;
                fw.write(new StringBuilder(30 + String.valueOf(string).length()).append("<context-root>/").append(string).append("</context-root>").toString());
                fw.write("</web>");
                fw.write("</module>");
            }
            fw.write("</application>");
        }
        fw = Files.newBufferedWriter(new File(metaInf, "appengine-application.xml").toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        var5_5 = null;
        try {
            fw.write("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n");
            fw.write("<appengine-application xmlns=\"http://appengine.google.com/ns/1.0\">");
            String applicationValue = this.applicationId == null ? "localdevapp" : this.applicationId;
            fw.write(new StringBuilder(51 + String.valueOf(applicationValue).length()).append("<application>").append(applicationValue).append("</application></appengine-application>").toString());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                DevAppServerMain.$closeResource(var5_5, fw);
            }
        }
        return path;
    }

    class StartAction
    extends Action {
        StartAction() {
            super("start");
        }

        @Override
        public void apply() {
            List<String> args = this.getArgs();
            try {
                if (args.isEmpty()) {
                    DevAppServerMain.this.printHelp(System.err);
                    System.exit(1);
                }
                for (String path : args) {
                    if (new File(path).exists()) continue;
                    System.out.println(String.valueOf(path).concat(" does not exist."));
                    DevAppServerMain.this.printHelp(System.err);
                    System.exit(1);
                }
                File appDir = args.size() == 1 ? new File(args.get(0)).getCanonicalFile() : DevAppServerMain.this.constructTemporaryEARDirectory(args);
                DevAppServerMain.this.validateWarPath(appDir);
                DevAppServerMain.this.configureRuntime(appDir);
                UpdateCheck updateCheck = new UpdateCheck(DevAppServerMain.this.versionCheckServer, appDir, true);
                if (updateCheck.allowedToCheckForUpdates() && !DevAppServerMain.this.disableUpdateCheck) {
                    updateCheck.maybePrintNagScreen(System.err);
                }
                updateCheck.checkJavaVersion(System.err);
                boolean installSecurityManager = !Boolean.getBoolean("use_jetty9_runtime");
                DevAppServer server = new DevAppServerFactory().createDevAppServer(appDir, null, null, DevAppServerMain.this.address, DevAppServerMain.this.port, true, installSecurityManager, ImmutableMap.of(), DevAppServerMain.this.getNoJavaAgent(), DevAppServerMain.this.applicationId);
                Map<String, String> stringProperties = DevAppServerMain.this.getSystemProperties();
                this.setGeneratedDirectory(stringProperties);
                this.setRdbmsPropertiesFile(stringProperties, appDir);
                DevAppServerMain.this.postServerActions(stringProperties);
                this.setDefaultGcsBucketName(stringProperties);
                DevAppServerMain.this.addPropertyOptionToProperties(stringProperties);
                server.setServiceProperties(stringProperties);
                try {
                    server.start().await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Shutting down.");
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }

        private void setGeneratedDirectory(Map<String, String> stringProperties) {
            if (DevAppServerMain.this.generatedDirectory != null) {
                File dir = new File(DevAppServerMain.this.generatedDirectory);
                String error = null;
                if (dir.exists()) {
                    if (!dir.isDirectory()) {
                        error = String.valueOf(DevAppServerMain.this.generatedDirectory).concat(" is not a directory.");
                    } else if (!dir.canWrite()) {
                        error = String.valueOf(DevAppServerMain.this.generatedDirectory).concat(" is not writable.");
                    }
                } else if (!dir.mkdirs()) {
                    String string = String.valueOf(DevAppServerMain.this.generatedDirectory);
                    String string2 = error = string.length() != 0 ? "Could not make ".concat(string) : new String("Could not make ");
                }
                if (error != null) {
                    System.err.println(error);
                    System.exit(1);
                }
                stringProperties.put("appengine.generated.dir", DevAppServerMain.this.generatedDirectory);
            }
        }

        private void setDefaultGcsBucketName(Map<String, String> stringProperties) {
            if (DevAppServerMain.this.defaultGcsBucketName != null) {
                stringProperties.put("appengine.default.gcs.bucket.name", DevAppServerMain.this.defaultGcsBucketName);
            }
        }

        private void setRdbmsPropertiesFile(Map<String, String> stringProperties, File appDir) {
            if (stringProperties.get(DevAppServerMain.RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY) != null) {
                return;
            }
            File file = this.findRdbmsPropertiesFile(appDir);
            if (file != null) {
                String path = file.getPath();
                String string = String.valueOf(path);
                System.out.println(string.length() != 0 ? "Reading local rdbms properties from ".concat(string) : new String("Reading local rdbms properties from "));
                stringProperties.put(DevAppServerMain.RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY, path);
            }
        }

        private File findRdbmsPropertiesFile(File dir) {
            File candidate = new File(dir, DevAppServerMain.DEFAULT_RDBMS_PROPERTIES_FILE);
            if (candidate.isFile() && candidate.canRead()) {
                return candidate;
            }
            return null;
        }
    }
}

