/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class ClassicSdk
extends AppengineSdk {
    ClassicSdk() {
    }

    @Override
    public void includeTestingJarOnSharedPath(boolean val) {
        SdkInfo.includeTestingJarOnSharedPath(val);
    }

    @Override
    public File getToolsApiJarFile() {
        return new File(String.valueOf(this.getSdkRoot()).concat("/lib/appengine-tools-api.jar"));
    }

    @Override
    public List<URL> getAgentRuntimeLibs() {
        return SdkImplInfo.getAgentRuntimeLibs();
    }

    @Override
    public List<File> getUserJspLibFiles() {
        return SdkImplInfo.getUserJspLibFiles();
    }

    @Override
    public List<File> getUserLibFiles() {
        return SdkInfo.getUserLibFiles();
    }

    @Override
    public List<URL> getWebApiToolsLibs() {
        return SdkImplInfo.getWebApiToolLibs();
    }

    @Override
    public List<File> getSharedJspLibFiles() {
        return SdkImplInfo.getSharedJspLibFiles();
    }

    @Override
    public List<URL> getImplLibs() {
        return SdkImplInfo.getImplLibs();
    }

    @Override
    public List<File> getSharedLibFiles() {
        return SdkInfo.getSharedLibFiles();
    }

    @Override
    public List<URL> getDatanucleusLibs(String version) {
        this.validateDatanucleusVersions(version);
        return SdkInfo.getOptionalToolsLib("datanucleus").getURLsForVersion(version);
    }

    @Override
    public String getQuickStartClasspath(AppengineSdk.WebDefaultXmlType jettyVersion) {
        ArrayList<String> list = new ArrayList<String>();
        File quickstart = new File(this.getSdkRoot(), "lib/tools/quickstart/quickstartgenerator.jar");
        if (jettyVersion == AppengineSdk.WebDefaultXmlType.JETTY93_STANDARD) {
            File jettyDir = new File(this.getSdkRoot(), "jetty94/jetty-home/lib");
            for (File f : jettyDir.listFiles()) {
                if (f.isDirectory() || f.getName().startsWith("cdi-")) continue;
                list.add(f.getAbsolutePath());
            }
            for (File f : new File(jettyDir, "annotations").listFiles()) {
                list.add(f.getAbsolutePath());
            }
            list.add(quickstart.getAbsolutePath());
        } else {
            File jettyDir = new File(String.valueOf(this.getSdkRoot()).concat("/lib/java-managed-vm/appengine-java-vmruntime"));
            File dir = new File(jettyDir, "lib");
            list.add(quickstart.getAbsolutePath());
            for (File f : dir.listFiles()) {
                list.add(f.getAbsolutePath());
            }
            for (File f : new File(dir, "jsp").listFiles()) {
                if (f.getName().startsWith("taglibs")) continue;
                list.add(f.getAbsolutePath());
            }
            for (File f : new File(dir, "jndi").listFiles()) {
                list.add(f.getAbsolutePath());
            }
        }
        return Joiner.on(System.getProperty("path.separator")).join(list);
    }

    @Override
    public String getWebDefaultXml(AppengineSdk.WebDefaultXmlType jettyVersion) {
        switch (jettyVersion) {
            case JETTY92_VM: {
                return String.valueOf(this.getSdkRoot()).concat("/lib/jetty-base-sdk/etc/webdefault.xml");
            }
            case JETTY93_VM_ASYNC: {
                return String.valueOf(this.getSdkRoot()).concat("/jetty93-base/etc/webdefault.xml");
            }
            case JETTY93_STANDARD: {
                return String.valueOf(this.getSdkRoot()).concat("/docs/webdefault.xml");
            }
        }
        String string = String.valueOf((Object)jettyVersion);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Invalid Jetty version: ").append(string).toString());
    }

    public String getSdkRoot() {
        return SdkInfo.getSdkRoot().getAbsolutePath();
    }

    @Override
    public File getResourcesDirectory() {
        return new File(this.getSdkRoot(), "docs");
    }

    @Override
    public File getAgentJarFile() {
        return new File(String.valueOf(this.getSdkRoot()).concat("/lib/agent/appengine-agent.jar"));
    }

    @Override
    public List<URL> getSharedLibs() {
        return SdkInfo.getSharedLibs();
    }

    @Override
    public File getLoggingProperties() {
        return SdkImplInfo.getLoggingProperties();
    }
}

