/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.LocalVersionFactory;
import com.google.appengine.tools.info.OptionalLib;
import com.google.appengine.tools.info.Version;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class SdkInfo {
    public static final String SDK_ROOT_PROPERTY = "appengine.sdk.root";
    private static final String DEFAULT_SERVER = "appengine.google.com";
    static final String JETTY9_HOME_LIB_PATH = "jetty94/jetty-home/lib";
    private static boolean isInitialized = false;
    private static File sdkRoot = null;
    private static List<File> userLibFiles = null;
    private static List<URL> userLibs = null;
    private static SortedMap<String, OptionalLib> optionalUserLibsByName = null;
    private static SortedMap<String, OptionalLib> optionalToolsLibsByName = null;
    private static boolean isDevAppServerTest;
    private static final FileFilter NO_HIDDEN_FILES;

    static List<URL> toURLs(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            urls.add(SdkInfo.toURL(file));
        }
        return urls;
    }

    static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            String string = String.valueOf(file);
            throw new RuntimeException(new StringBuilder(22 + String.valueOf(string).length()).append("Unable get a URL from ").append(string).toString(), e);
        }
    }

    static List<File> getLibs(File sdkRoot, String libSubDir) {
        return SdkInfo.getLibs(sdkRoot, libSubDir, false);
    }

    static List<File> getLibsRecursive(File sdkRoot, String libSubDir) {
        return SdkInfo.getLibs(sdkRoot, libSubDir, true);
    }

    private static List<File> getLibs(File sdkRoot, String libSubDir, boolean recursive) {
        String string = File.separator;
        File subDir = new File(sdkRoot, new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(libSubDir).length()).append("lib").append(string).append(libSubDir).toString());
        if (!subDir.exists()) {
            String string2 = String.valueOf(subDir.getAbsolutePath());
            throw new IllegalArgumentException(string2.length() != 0 ? "Unable to find ".concat(string2) : new String("Unable to find "));
        }
        ArrayList<File> libs = new ArrayList<File>();
        SdkInfo.getLibs(subDir, libs, recursive);
        return libs;
    }

    private static void getLibs(File dir, List<File> list, boolean recursive) {
        for (File f : SdkInfo.listFiles(dir)) {
            if (f.isDirectory() && recursive) {
                SdkInfo.getLibs(f, list, recursive);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            list.add(f);
        }
    }

    private static File findSdkRoot() {
        File libDir;
        String explicitRootString = System.getProperty(SDK_ROOT_PROPERTY);
        if (explicitRootString != null) {
            return new File(explicitRootString);
        }
        URL codeLocation = SdkInfo.class.getProtectionDomain().getCodeSource().getLocation();
        String string = String.valueOf(codeLocation);
        String msg = new StringBuilder(191 + String.valueOf(string).length()).append("Unable to discover the Google App Engine SDK root. This code should be loaded from the SDK directory, but was instead loaded from ").append(string).append(".  Specify -Dappengine.sdk.root to override the SDK location.").toString();
        try {
            libDir = new File(codeLocation.toURI());
        }
        catch (URISyntaxException e) {
            libDir = new File(codeLocation.getFile());
        }
        while (!libDir.getName().equals("lib")) {
            if ((libDir = libDir.getParentFile()) != null) continue;
            throw new RuntimeException(msg);
        }
        return libDir.getParentFile();
    }

    public static List<URL> getSharedLibs() {
        SdkInfo.init();
        return Collections.unmodifiableList(SdkInfo.toURLs(SdkInfo.getSharedLibFiles()));
    }

    public static List<File> getSharedLibFiles() {
        SdkInfo.init();
        return SdkInfo.determineSharedLibFiles();
    }

    @Deprecated
    public static List<URL> getUserLibs() {
        SdkInfo.init();
        return userLibs;
    }

    @Deprecated
    public static List<File> getUserLibFiles() {
        SdkInfo.init();
        return userLibFiles;
    }

    public static Collection<OptionalLib> getOptionalUserLibs() {
        SdkInfo.init();
        return optionalUserLibsByName.values();
    }

    public static OptionalLib getOptionalUserLib(String name) {
        SdkInfo.init();
        return (OptionalLib)optionalUserLibsByName.get(name);
    }

    public static Collection<OptionalLib> getOptionalToolsLibs() {
        SdkInfo.init();
        return optionalToolsLibsByName.values();
    }

    public static OptionalLib getOptionalToolsLib(String name) {
        SdkInfo.init();
        return (OptionalLib)optionalToolsLibsByName.get(name);
    }

    public static File getSdkRoot() {
        SdkInfo.init();
        return sdkRoot;
    }

    public static synchronized void setSdkRoot(File root) {
        if (isInitialized && !sdkRoot.equals(root)) {
            throw new IllegalStateException("Cannot set SDK root after initialization has occurred.");
        }
        sdkRoot = root;
    }

    public static Version getLocalVersion() {
        return new LocalVersionFactory(SdkInfo.getUserLibFiles()).getVersion();
    }

    public static String getDefaultServer() {
        return DEFAULT_SERVER;
    }

    public static void includeTestingJarOnSharedPath(boolean val) {
        isDevAppServerTest = val;
    }

    private static synchronized void init() {
        if (!isInitialized) {
            String string;
            if (sdkRoot == null) {
                sdkRoot = SdkInfo.findSdkRoot();
            }
            userLibFiles = new File(sdkRoot, new StringBuilder(7 + String.valueOf(string = File.separator).length()).append("lib").append(string).append("user").toString()).isDirectory() ? Collections.unmodifiableList(SdkInfo.getLibsRecursive(sdkRoot, "user")) : Collections.emptyList();
            userLibs = Collections.unmodifiableList(SdkInfo.toURLs(userLibFiles));
            optionalUserLibsByName = Collections.unmodifiableSortedMap(SdkInfo.determineOptionalUserLibs());
            optionalToolsLibsByName = Collections.unmodifiableSortedMap(SdkInfo.determineOptionalToolsLibs());
            isInitialized = true;
        }
    }

    private static SortedMap<String, OptionalLib> determineOptionalUserLibs() {
        return SdkInfo.determineOptionalLibs(new File(sdkRoot, "lib/opt/user"));
    }

    private static SortedMap<String, OptionalLib> determineOptionalToolsLibs() {
        return SdkInfo.determineOptionalLibs(new File(sdkRoot, "lib/opt/tools"));
    }

    private static SortedMap<String, OptionalLib> determineOptionalLibs(File root) {
        TreeMap<String, OptionalLib> map = new TreeMap<String, OptionalLib>();
        for (File libDir : SdkInfo.listFiles(root)) {
            TreeMap<String, List<File>> filesByVersion = new TreeMap<String, List<File>>();
            for (File version : SdkInfo.listFiles(libDir)) {
                ArrayList<File> filesForVersion = new ArrayList<File>();
                SdkInfo.getLibs(version, filesForVersion, true);
                filesByVersion.put(version.getName(), filesForVersion);
            }
            String description = "";
            OptionalLib userLib = new OptionalLib(libDir.getName(), description, filesByVersion);
            map.put(userLib.getName(), userLib);
        }
        return map;
    }

    private static List<File> getJetty9Jars(String subDir) {
        String string = File.separator;
        File path = new File(sdkRoot, new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(subDir).length()).append(JETTY9_HOME_LIB_PATH).append(string).append(subDir).toString());
        if (!path.exists()) {
            String string2 = String.valueOf(path.getAbsolutePath());
            throw new IllegalArgumentException(string2.length() != 0 ? "Unable to find ".concat(string2) : new String("Unable to find "));
        }
        ArrayList<File> jars = new ArrayList<File>();
        for (File f : SdkInfo.listFiles(path)) {
            if (!f.getName().endsWith(".jar") || f.getName().startsWith("cdi")) continue;
            jars.add(f);
        }
        return jars;
    }

    static List<File> getJetty9JspJars() {
        List<File> lf = SdkInfo.getJetty9Jars("apache-jsp");
        lf.addAll(SdkInfo.getJetty9Jars("apache-jstl"));
        return lf;
    }

    static List<File> getImplJars() {
        if (Version.isJetty9()) {
            List<File> lf = SdkInfo.getLibs(sdkRoot, "impl");
            lf.addAll(SdkInfo.getJetty9Jars(""));
            lf.addAll(SdkInfo.getJetty9JspJars());
            lf.addAll(SdkInfo.getJetty9Jars("annotations"));
            return Collections.unmodifiableList(lf);
        }
        return Collections.unmodifiableList(SdkInfo.getLibs(SdkInfo.getSdkRoot(), "impl"));
    }

    static List<File> getJetty9SharedLibFiles() {
        ArrayList<File> sharedLibs = new ArrayList<File>();
        sharedLibs.add(new File(sdkRoot, "lib/shared/appengine-local-runtime-shared.jar"));
        File jettyHomeLib = new File(sdkRoot, JETTY9_HOME_LIB_PATH);
        sharedLibs.add(new File(jettyHomeLib, "servlet-api-3.1.jar"));
        sharedLibs.add(new File(jettyHomeLib, "jetty-schemas-3.1.jar"));
        class JettyVersionFilter
        implements FileFilter {
            JettyVersionFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("jetty-util-");
            }
        }
        File[] files = jettyHomeLib.listFiles(new JettyVersionFilter());
        sharedLibs.addAll(Arrays.asList(files));
        sharedLibs.addAll(SdkInfo.getJetty9JspJars());
        return sharedLibs;
    }

    private static List<File> determineSharedLibFiles() {
        List<File> sharedLibs = Version.isJetty9() ? SdkInfo.getJetty9SharedLibFiles() : SdkInfo.getLibsRecursive(sdkRoot, "shared");
        if (isDevAppServerTest) {
            sharedLibs.addAll(SdkInfo.getLibsRecursive(sdkRoot, "testing"));
        }
        return Collections.unmodifiableList(sharedLibs);
    }

    static File[] listFiles(File dir) {
        File[] files = dir.listFiles(NO_HIDDEN_FILES);
        if (files == null) {
            return new File[0];
        }
        return files;
    }

    static {
        NO_HIDDEN_FILES = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden();
            }
        };
    }
}

