/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class Version {
    public static final Version UNKNOWN = new Version(null, null, null);
    private final String release;
    private final Date timestamp;
    private final Set<String> apiVersions;
    private static boolean useJetty9 = Boolean.getBoolean("use_jetty9_runtime");

    Version(String release, Date timestamp, Set<String> apiVersions) {
        this.release = release;
        this.timestamp = timestamp;
        this.apiVersions = apiVersions == null ? null : Collections.unmodifiableSet(apiVersions);
    }

    public static boolean isJetty9() {
        return useJetty9;
    }

    public static void setUseJetty9(boolean b) {
        useJetty9 = b;
    }

    public String getRelease() {
        return this.release;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<String> getApiVersions() {
        return this.apiVersions;
    }

    public String toString() {
        String string;
        StringBuilder builder = new StringBuilder();
        if (this.release == null) {
            builder.append("Release: (unknown)\n");
        } else {
            string = this.release;
            builder.append(new StringBuilder(10 + String.valueOf(string).length()).append("Release: ").append(string).append("\n").toString());
        }
        if (this.timestamp == null) {
            builder.append("Timestamp: (unknown)\n");
        } else {
            string = String.valueOf(this.timestamp);
            builder.append(new StringBuilder(12 + String.valueOf(string).length()).append("Timestamp: ").append(string).append("\n").toString());
        }
        if (this.apiVersions != null) {
            string = String.valueOf(this.apiVersions);
            builder.append(new StringBuilder(15 + String.valueOf(string).length()).append("API versions: ").append(string).append("\n").toString());
        } else {
            builder.append("API versions: (unknown)\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiVersions == null ? 0 : this.apiVersions.hashCode());
        result = 31 * result + (this.release == null ? 0 : this.release.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.apiVersions == null ? other.apiVersions != null : !this.apiVersions.equals(other.apiVersions)) {
            return false;
        }
        if (this.release == null ? other.release != null : !this.release.equals(other.release)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }
}

