/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.security.preverifier;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClassSource {
    private List<ClassPathElement> classPathElements;

    ClassSource() {
    }

    public void addDirectoryClassPathElement(String dirName) {
        DirectoryElement e = new DirectoryElement(dirName);
        this.classPathElements.add(e);
    }

    public void addJarClassPathElement(String jarName) {
        try {
            JarElement e = new JarElement(jarName);
            this.classPathElements.add(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public URL findResource(String name) {
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            return e.getResourceURL(name);
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> l = new ArrayList<URL>();
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            l.add(e.getResourceURL(name));
        }
        return Collections.enumeration(l);
    }

    public byte[] getClassData(String name) throws ClassNotFoundException {
        String resourceName = String.valueOf(name.replace('.', '/')).concat(".class");
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(resourceName)) continue;
            return e.getResourceData(resourceName);
        }
        throw new ClassNotFoundException(name);
    }

    public void setClassPath(List<String> classPath) {
        this.classPathElements = new LinkedList<ClassPathElement>();
        for (String pathEntry : classPath) {
            File f = new File(pathEntry);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                this.addDirectoryClassPathElement(pathEntry);
                continue;
            }
            this.addJarClassPathElement(pathEntry);
        }
    }

    public void setClassPath(String classPath) {
        ArrayList<String> l = new ArrayList<String>();
        if (classPath != null) {
            StringTokenizer t = new StringTokenizer(classPath, File.pathSeparator);
            while (t.hasMoreTokens()) {
                l.add(t.nextToken());
            }
        }
        this.setClassPath(l);
    }

    private static class JarElement
    extends ClassPathElement {
        private final String jarName;
        private final ZipFile jarFile;

        JarElement(String jarName) throws IOException {
            this.jarName = jarName;
            this.jarFile = new ZipFile(jarName);
        }

        @Override
        protected InputStream getResourceStream(String name) {
            assert (this.hasResource(name));
            try {
                ZipEntry entry = this.jarFile.getEntry(name);
                return this.jarFile.getInputStream(entry);
            }
            catch (IOException ioe) {
                return null;
            }
        }

        @Override
        protected URL getResourceURL(String name) {
            assert (this.hasResource(name));
            try {
                String string = this.jarName;
                return new URL(new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(name).length()).append("jar:file:").append(string).append("!/").append(name).toString());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        protected boolean hasResource(String name) {
            ZipEntry entry = this.jarFile.getEntry(name);
            return entry != null;
        }
    }

    private static class DirectoryElement
    extends ClassPathElement {
        private final String dirName;

        DirectoryElement(String dirName) {
            this.dirName = dirName;
        }

        @Override
        protected InputStream getResourceStream(String name) {
            assert (this.hasResource(name));
            try {
                String string = this.dirName;
                char c = File.separatorChar;
                File f = new File(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append(c).append(name).toString());
                return new FileInputStream(f);
            }
            catch (IOException ioe) {
                return null;
            }
        }

        @Override
        protected URL getResourceURL(String name) {
            assert (this.hasResource(name));
            String string = this.dirName;
            char c = File.separatorChar;
            String fullPath = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append(c).append(name).toString();
            try {
                String string2 = String.valueOf(fullPath);
                return new URL(string2.length() != 0 ? "file:".concat(string2) : new String("file:"));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        protected boolean hasResource(String name) {
            String string = this.dirName;
            char c = File.separatorChar;
            String fullPath = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append(c).append(name).toString();
            File f = new File(fullPath);
            return f.exists() && f.isFile();
        }
    }

    private static abstract class ClassPathElement {
        private ClassPathElement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] getResourceData(String name) {
            assert (this.hasResource(name));
            InputStream is = this.getResourceStream(name);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataInputStream ds = new DataInputStream(is);
            byte[] b = new byte[2048];
            try {
                int i;
                while ((i = ds.read(b)) != -1) {
                    bos.write(b, 0, i);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    ds.close();
                }
                catch (IOException iOException) {}
            }
        }

        protected abstract InputStream getResourceStream(String var1);

        protected abstract URL getResourceURL(String var1);

        protected abstract boolean hasResource(String var1);
    }
}

