/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.security.preverifier;

import com.google.apphosting.runtime.security.preverifier.ClassSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class RefVerifier {
    private static List<String> jreJars = Arrays.asList("lib/security/US_export_policy.jar", "lib/security/local_policy.jar", "lib/ext/sunjce_provider.jar", "lib/ext/sunpkcs11.jar", "lib/ext/dnsns.jar", "lib/ext/localedata.jar", "lib/jce.jar", "lib/javaws.jar", "lib/jsse.jar", "lib/im/indicim.jar", "lib/im/thaiim.jar", "lib/deploy.jar", "lib/charsets.jar", "lib/plugin.jar", "lib/rt.jar");
    private static final String NL = System.getProperty("line.separator");
    private String currentClassName;
    private final ClassSource classSource;
    private final Map<String, SoftReference<ClassReader>> classReaderCache = new HashMap<String, SoftReference<ClassReader>>();
    private Collection<String> whiteList;
    private List<RefError> refErrors;
    private String currentReferrer = null;
    private Integer currentLine = null;

    public static String getUsage() {
        String string = NL;
        String string2 = NL;
        String string3 = NL;
        return new StringBuilder(135 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Usage: RefVerifier <options>").append(string).append(" Options: ").append(string2).append(" -class <path to class to verify> (required) ").append(string3).append(" -cp <classpath containing valid classes> (required)").toString();
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> classpath = new ArrayList<String>();
        String classfile = null;
        for (int i = 0; i < args.length; ++i) {
            String command = args[i];
            ++i;
            if ("-class".equals(command)) {
                classfile = args[i];
                continue;
            }
            if ("-cp".equals(command)) {
                String path = args[i];
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    classpath.add(st.nextToken());
                }
                continue;
            }
            String string = String.valueOf(command);
            System.out.println(string.length() != 0 ? "I don't understand the command: ".concat(string) : new String("I don't understand the command: "));
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        if (classfile == null) {
            System.out.println("Option \"-class\" is required.");
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        ArrayList<String> whiteList = new ArrayList<String>();
        RefVerifier vr = new RefVerifier(whiteList, classpath);
        vr.verifyClass(classfile);
    }

    private RefVerifier(Collection<String> whiteList, List<String> jreClassPath) {
        this.classSource = new ClassSource();
        this.classSource.setClassPath(jreClassPath);
        this.whiteList = whiteList;
    }

    public static RefVerifier newVerifierForJRE(String jrePath, Collection<String> whiteList) {
        String separator = File.separator;
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : jreJars) {
            paths.add(new StringBuilder(String.valueOf(jrePath).length() + String.valueOf(separator).length() + String.valueOf(path).length()).append(jrePath).append(separator).append(path).toString());
        }
        return new RefVerifier(whiteList, paths);
    }

    private void reset() {
        this.currentClassName = null;
        this.refErrors = null;
        this.currentReferrer = null;
        this.currentLine = null;
    }

    private <T> List<T> dedupe(List<T> list) {
        HashSet<T> s = new HashSet<T>(list);
        return new ArrayList<T>(s);
    }

    public List<RefError> verifyClass(String classFileName) throws IOException {
        return this.verifyClass(new FileInputStream(classFileName));
    }

    public List<RefError> verifyClass(InputStream input) throws IOException {
        this.refErrors = new ArrayList<RefError>();
        this.doVerifyClass(input);
        List<RefError> returnErrors = this.dedupe(this.refErrors);
        this.reset();
        return returnErrors;
    }

    public List<RefError> verifyClasses(List<String> classes) throws IOException {
        this.refErrors = new ArrayList<RefError>();
        for (String sourcePath : classes) {
            this.doVerifyClass(new FileInputStream(sourcePath));
        }
        List<RefError> returnErrors = this.dedupe(this.refErrors);
        this.reset();
        return returnErrors;
    }

    public List<RefError> verifyJarFile(String jarFileName) throws IOException {
        this.refErrors = new ArrayList<RefError>();
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            InputStream input = jarFile.getInputStream(entry);
            this.doVerifyClass(input);
        }
        List<RefError> returnErrors = this.dedupe(this.refErrors);
        this.reset();
        return returnErrors;
    }

    private void checkClassName(String className) {
        Type t = Type.getType((String)className);
        this.checkClassName(t);
    }

    private void checkClassName(Type t) {
        String name;
        switch (t.getSort()) {
            case 9: {
                t = t.getElementType();
                if (t.getSort() != 10) {
                    return;
                }
            }
            case 10: {
                name = t.getClassName();
                break;
            }
            default: {
                return;
            }
        }
        this.checkSimpleClassName(name);
    }

    private void checkClassNameInType(String className) {
        switch (className.charAt(0)) {
            case 'L': 
            case '[': {
                this.checkClassName(className);
                break;
            }
            default: {
                this.checkSimpleClassName(className);
            }
        }
    }

    private void checkSimpleClassName(String className) {
        String name = className.replace('/', '.');
        if (this.whiteList.contains(name)) {
            return;
        }
        try {
            this.getClassReader(name);
            this.refErrors.add(new RefError(name, new RefSite(this.currentClassName, this.currentReferrer, this.currentLine)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void doVerifyClass(InputStream sourceStream) throws IOException {
        ClassReader cr = new ClassReader(sourceStream);
        cr.accept((ClassVisitor)new ClassVerifier(), 0);
    }

    private ClassReader getClassReader(String className) throws ClassNotFoundException {
        ClassReader reader = null;
        SoftReference<ClassReader> ref = this.classReaderCache.get(className);
        if (ref != null) {
            reader = ref.get();
        }
        if (reader == null) {
            byte[] b = this.classSource.getClassData(className);
            reader = new ClassReader(b);
            this.classReaderCache.put(className, new SoftReference<ClassReader>(reader));
        }
        return reader;
    }

    private class ClassVerifier
    extends ClassVisitor {
        public ClassVerifier() {
            super(393216, (ClassVisitor)new EmptyClassVisitor());
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            RefVerifier.this.currentClassName = name.replace('/', '.');
            if (superName != null) {
                RefVerifier.this.checkSimpleClassName(superName);
            }
            if (interfaces != null) {
                for (int i = 0; i < interfaces.length; ++i) {
                    RefVerifier.this.checkSimpleClassName(interfaces[i]);
                }
            }
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            RefVerifier.this.currentLine = null;
            RefVerifier.this.currentReferrer = name;
            RefVerifier.this.checkClassNameInType(desc);
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name != null) {
                RefVerifier.this.checkSimpleClassName(name);
            }
            if (outerName != null) {
                RefVerifier.this.checkSimpleClassName(outerName);
            }
            this.cv.visitInnerClass(name, outerName, innerName, access);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Type[] argTypes;
            RefVerifier.this.currentReferrer = name;
            if (exceptions != null) {
                for (String s : exceptions) {
                    RefVerifier.this.checkSimpleClassName(s);
                }
            }
            for (Type t : argTypes = Type.getArgumentTypes((String)desc)) {
                RefVerifier.this.checkClassName(t);
            }
            RefVerifier.this.checkClassName(Type.getReturnType((String)desc));
            return new MethodVerifier(this.cv.visitMethod(access, name, desc, signature, exceptions));
        }

        public void visitOuterClass(String owner, String name, String desc) {
            RefVerifier.this.checkSimpleClassName(owner);
            this.cv.visitOuterClass(owner, name, desc);
        }
    }

    private static class EmptyClassVisitor
    extends ClassVisitor {
        private final FieldVisitor fv = new FieldVisitor(this, 393216){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new EmptyAnnotationVisitor();
            }
        };
        private final MethodVisitor mv = new MethodVisitor(this, 393216){

            public AnnotationVisitor visitAnnotationDefault() {
                return new EmptyAnnotationVisitor();
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new EmptyAnnotationVisitor();
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                return new EmptyAnnotationVisitor();
            }
        };

        EmptyClassVisitor() {
            super(393216);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new EmptyAnnotationVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return this.fv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.mv;
        }
    }

    private static class EmptyAnnotationVisitor
    extends AnnotationVisitor {
        EmptyAnnotationVisitor() {
            super(393216);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private class MethodVerifier
    extends MethodVisitor {
        MethodVerifier(MethodVisitor mv) {
            super(393216, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            RefVerifier.this.checkSimpleClassName(owner);
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                RefVerifier.this.checkClassName((Type)cst);
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitLineNumber(int line, Label start) {
            RefVerifier.this.currentLine = line;
            this.mv.visitLineNumber(line, start);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            RefVerifier.this.checkClassName(desc);
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            RefVerifier.this.checkSimpleClassName(owner);
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            RefVerifier.this.checkClassName(desc);
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTypeInsn(int opcode, String desc) {
            RefVerifier.this.checkClassNameInType(desc);
            this.mv.visitTypeInsn(opcode, desc);
        }
    }

    public static class RefSite {
        private String klass;
        private String referrer;
        private Integer lineNumber;

        public RefSite(String klass, String referrer, Integer lineNumber) {
            this.klass = klass;
            this.referrer = referrer;
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefSite refSite = (RefSite)o;
            if (!this.klass.equals(refSite.klass)) {
                return false;
            }
            if (this.lineNumber != null ? !this.lineNumber.equals(refSite.lineNumber) : refSite.lineNumber != null) {
                return false;
            }
            return !(this.referrer != null ? !this.referrer.equals(refSite.referrer) : refSite.referrer != null);
        }

        public String getKlass() {
            return this.klass;
        }

        public int getNotNullLineNumber() {
            return this.lineNumber == null ? -1 : this.lineNumber;
        }

        public String getReferrer() {
            return this.referrer;
        }

        public int hashCode() {
            int result = this.klass.hashCode();
            result = 31 * result + (this.referrer != null ? this.referrer.hashCode() : 0);
            result = 31 * result + (this.lineNumber != null ? this.lineNumber.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.klass);
            if (this.referrer != null) {
                buf.append(".").append(this.referrer);
            }
            buf.append(":").append(this.getNotNullLineNumber());
            return buf.toString();
        }
    }

    public static class RefError {
        String unavailableClass;
        RefSite site;

        RefError(String unavailableClass, RefSite site) {
            this.unavailableClass = unavailableClass;
            this.site = site;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefError refError = (RefError)o;
            if (!this.site.equals(refError.site)) {
                return false;
            }
            return this.unavailableClass.equals(refError.unavailableClass);
        }

        public RefSite getSite() {
            return this.site;
        }

        public String getUnavailableClass() {
            return this.unavailableClass;
        }

        public int hashCode() {
            int result = this.unavailableClass.hashCode();
            result = 31 * result + this.site.hashCode();
            return result;
        }

        public String toString() {
            String string = this.unavailableClass;
            String string2 = String.valueOf(this.site);
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
        }
    }
}

