/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.NIOBuffer;

public class DirectNIOBuffer
extends AbstractBuffer
implements NIOBuffer {
    protected ByteBuffer _buf;
    private ReadableByteChannel _in;
    private InputStream _inStream;
    private WritableByteChannel _out;
    private OutputStream _outStream;

    public DirectNIOBuffer(int n) {
        super(2, false);
        this._buf = ByteBuffer.allocateDirect(n);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
    }

    public DirectNIOBuffer(ByteBuffer byteBuffer, boolean bl) {
        super(bl ? 0 : 2, false);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        this._buf = byteBuffer;
        this.setGetIndex(byteBuffer.position());
        this.setPutIndex(byteBuffer.limit());
    }

    public DirectNIOBuffer(File file) throws IOException {
        super(1, false);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        this._buf = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
        this._access = 0;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public byte[] array() {
        return null;
    }

    @Override
    public int capacity() {
        return this._buf.capacity();
    }

    @Override
    public byte peek(int n) {
        return this._buf.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peek(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3;
        if (n + n4 > this.capacity() && (n4 = this.capacity() - n) == 0) {
            return -1;
        }
        if (n4 < 0) {
            return -1;
        }
        try {
            this._buf.position(n);
            this._buf.get(byArray, n2, n4);
        }
        finally {
            this._buf.position(0);
        }
        return n4;
    }

    @Override
    public void poke(int n, byte by) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index<0: " + n + "<0");
        }
        if (n > this.capacity()) {
            throw new IllegalArgumentException("index>capacity(): " + n + ">" + this.capacity());
        }
        this._buf.put(n, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int poke(int n, Buffer buffer) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        byte[] byArray = buffer.array();
        if (byArray != null) {
            int n2 = this.poke(n, byArray, buffer.getIndex(), buffer.length());
            return n2;
        }
        Buffer buffer2 = buffer.buffer();
        if (buffer2 instanceof DirectNIOBuffer) {
            ByteBuffer byteBuffer = ((DirectNIOBuffer)buffer2)._buf;
            if (byteBuffer == this._buf) {
                byteBuffer = this._buf.duplicate();
            }
            try {
                this._buf.position(n);
                int n3 = this._buf.remaining();
                int n4 = buffer.length();
                if (n4 > n3) {
                    n4 = n3;
                }
                byteBuffer.position(buffer.getIndex());
                byteBuffer.limit(buffer.getIndex() + n4);
                this._buf.put(byteBuffer);
                int n5 = n4;
                return n5;
            }
            finally {
                this._buf.position(0);
                byteBuffer.limit(byteBuffer.capacity());
                byteBuffer.position(0);
            }
        }
        return super.poke(n, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int poke(int n, byte[] byArray, int n2, int n3) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index<0: " + n + "<0");
        }
        if (n + n3 > this.capacity() && (n3 = this.capacity() - n) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + n + ">" + this.capacity());
        }
        try {
            this._buf.position(n);
            int n4 = this._buf.remaining();
            if (n3 > n4) {
                n3 = n4;
            }
            if (n3 > 0) {
                this._buf.put(byArray, n2, n3);
            }
            int n5 = n3;
            return n5;
        }
        finally {
            this._buf.position(0);
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this._buf;
    }

    @Override
    public int readFrom(InputStream inputStream, int n) throws IOException {
        if (this._in == null || !this._in.isOpen() || inputStream != this._inStream) {
            this._in = Channels.newChannel(inputStream);
            this._inStream = inputStream;
        }
        if (n < 0 || n > this.space()) {
            n = this.space();
        }
        int n2 = this.putIndex();
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = n;
            int n6 = 0;
            while (n4 < n) {
                this._buf.position(n2);
                this._buf.limit(n2 + n5);
                n3 = this._in.read(this._buf);
                if (n3 < 0) {
                    this._in = null;
                    this._inStream = inputStream;
                    break;
                }
                if (n3 > 0) {
                    n4 += n3;
                    n5 -= n3;
                    this.setPutIndex(n2 += n3);
                    n6 = 0;
                } else if (n6++ > 1) break;
                if (inputStream.available() > 0) continue;
            }
            if (n3 < 0 && n4 == 0) {
                int n7 = -1;
                return n7;
            }
            int n8 = n4;
            return n8;
        }
        catch (IOException iOException) {
            this._in = null;
            this._inStream = inputStream;
            throw iOException;
        }
        finally {
            if (this._in != null && !this._in.isOpen()) {
                this._in = null;
                this._inStream = inputStream;
            }
            this._buf.position(0);
            this._buf.limit(this._buf.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this._out == null || !this._out.isOpen() || this._out != this._outStream) {
            this._out = Channels.newChannel(outputStream);
            this._outStream = outputStream;
        }
        ByteBuffer byteBuffer = this._buf;
        synchronized (byteBuffer) {
            try {
                int n = 0;
                while (this.hasContent() && this._out.isOpen()) {
                    this._buf.position(this.getIndex());
                    this._buf.limit(this.putIndex());
                    int n2 = this._out.write(this._buf);
                    if (n2 < 0) {
                    } else {
                        if (n2 > 0) {
                            this.skip(n2);
                            n = 0;
                            continue;
                        }
                        if (n++ <= 1) continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this._out = null;
                this._outStream = null;
                throw iOException;
            }
            finally {
                if (this._out != null && !this._out.isOpen()) {
                    this._out = null;
                    this._outStream = null;
                }
                this._buf.position(0);
                this._buf.limit(this._buf.capacity());
            }
        }
    }
}

