/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.Connection;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpException;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements Runnable {
    protected SelectorManager _manager;
    protected SelectorManager.SelectSet _selectSet;
    protected boolean _dispatched = false;
    protected boolean _writable = true;
    protected SelectionKey _key;
    protected int _interestOps;
    protected boolean _readBlocked;
    protected boolean _writeBlocked;
    protected Connection _connection;
    private Timeout.Task _timeoutTask = new IdleTask();

    public Connection getConnection() {
        return this._connection;
    }

    public SelectChannelEndPoint(SocketChannel socketChannel, SelectorManager.SelectSet selectSet, SelectionKey selectionKey) {
        super(socketChannel);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._connection = this._manager.newConnection(socketChannel, this);
        this._manager.endPointOpened(this);
        this._key = selectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch() throws IOException {
        boolean bl = true;
        try {
            if (this.dispatch(this._manager.isDelaySelectKeyUpdate())) {
                bl = false;
                bl = this._manager.dispatch(this);
            }
        }
        finally {
            if (!bl) {
                Log.warn("dispatch failed!");
                this.undispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(boolean bl) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return false;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                return false;
            }
            if (!bl) {
                this._key.interestOps(0);
            }
            if (this._dispatched) {
                this._key.interestOps(0);
                return false;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            this._dispatched = true;
        }
        return true;
    }

    public void scheduleIdle() {
        this._selectSet.scheduleIdle(this._timeoutTask);
    }

    public void cancelIdle() {
        this._selectSet.cancelIdle(this._timeoutTask);
    }

    protected void idleExpired() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            try {
                this._dispatched = false;
                this.updateKey();
            }
            catch (Exception exception) {
                Log.ignore(exception);
                this._interestOps = -1;
                this._selectSet.addChange(this);
            }
        }
    }

    @Override
    public int flush(Buffer buffer, Buffer buffer2, Buffer buffer3) throws IOException {
        int n = super.flush(buffer, buffer2, buffer3);
        this._writable = n > 0;
        return n;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        int n = super.flush(buffer);
        this._writable = n > 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockReadable(long l) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long l2 = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._readBlocked = true;
                    while (this.isOpen()) {
                        if (!this._readBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(l);
                            if (!this._readBlocked || l >= this._selectSet.getNow() - l2) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException interruptedException) {
                            Log.warn(interruptedException);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._readBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockWritable(long l) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long l2 = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._writeBlocked = true;
                    while (this.isOpen()) {
                        if (!this._writeBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(l);
                            if (!this._writeBlocked || l >= this._selectSet.getNow() - l2) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException interruptedException) {
                            Log.warn(interruptedException);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._writeBlocked = false;
            }
        }
    }

    public void setWritable(boolean bl) {
        this._writable = bl;
    }

    public void scheduleWrite() {
        this._writable = false;
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int n = -1;
            if (this.getChannel().isOpen()) {
                n = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                this._interestOps = (!this._dispatched || this._readBlocked ? 1 : 0) | (!this._writable || this._writeBlocked ? 4 : 0);
            }
            if (this._interestOps == n && this.getChannel().isOpen()) {
                return;
            }
        }
        this._selectSet.addChange(this);
        this._selectSet.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel selectableChannel = (SelectableChannel)((Object)this.getChannel());
                        if (selectableChannel.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception exception) {
                                Log.ignore(exception);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                this.cancelIdle();
                                this._manager.endPointClosed(this);
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.interestOps(0);
                    this._key.cancel();
                }
                this.cancelIdle();
                this._manager.endPointClosed(this);
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._connection.handle();
        }
        catch (ClosedChannelException closedChannelException) {
            Log.ignore(closedChannelException);
        }
        catch (EofException eofException) {
            Log.debug("EOF", (Object)eofException);
            try {
                this.close();
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
        }
        catch (HttpException httpException) {
            Log.debug("BAD", (Object)httpException);
            try {
                this.close();
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
        }
        catch (Throwable throwable) {
            Log.warn("handle failed", throwable);
            try {
                this.close();
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
        }
        finally {
            this.undispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
        finally {
            this.updateKey();
        }
    }

    public String toString() {
        return "SCEP@" + this.hashCode() + "[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
    }

    public Timeout.Task getTimeoutTask() {
        return this._timeoutTask;
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public class IdleTask
    extends Timeout.Task {
        public void expire() {
            SelectChannelEndPoint.this.idleExpired();
        }

        public String toString() {
            return "TimeoutTask:" + SelectChannelEndPoint.this.toString();
        }
    }
}

