/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.mortbay.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.mortbay.io.nio.MAX_SELECTS", 15000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.mortbay.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.mortbay.io.nio.BUSY_KEY", -1);
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long l) {
        this._maxIdleTime = l;
    }

    public void setSelectSets(int n) {
        long l = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = n;
        this._lowResourcesConnections = l / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel socketChannel, Object object) throws IOException {
        int n = this._set++;
        n %= this._selectSets;
        SelectSet[] selectSetArray = this._selectSet;
        if (selectSetArray != null) {
            SelectSet selectSet = selectSetArray[n];
            selectSet.addChange(socketChannel, object);
            selectSet.wakeup();
        }
    }

    public void register(ServerSocketChannel serverSocketChannel) throws IOException {
        int n = this._set++;
        SelectSet selectSet = this._selectSet[n %= this._selectSets];
        selectSet.addChange(serverSocketChannel);
        selectSet.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long l) {
        this._lowResourcesConnections = (l + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long l) {
        this._lowResourcesMaxIdleTime = l;
    }

    public void doSelect(int n) throws IOException {
        SelectSet[] selectSetArray = this._selectSet;
        if (selectSetArray != null && selectSetArray.length > n && selectSetArray[n] != null) {
            selectSetArray[n].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean bl) {
        this._delaySelectKeyUpdate = bl;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] selectSetArray = this._selectSet;
        this._selectSet = null;
        if (selectSetArray != null) {
            for (int i = 0; i < selectSetArray.length; ++i) {
                SelectSet selectSet = selectSetArray[i];
                if (selectSet == null) continue;
                selectSet.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel socketChannel, Throwable throwable, Object object) {
        Log.warn(throwable);
    }

    static /* synthetic */ long access$100(SelectorManager selectorManager) {
        return selectorManager._lowResourcesConnections;
    }

    static /* synthetic */ long access$200(SelectorManager selectorManager) {
        return selectorManager._lowResourcesMaxIdleTime;
    }

    static /* synthetic */ long access$300(SelectorManager selectorManager) {
        return selectorManager._maxIdleTime;
    }

    static /* synthetic */ int access$400() {
        return __BUSY_PAUSE;
    }

    static /* synthetic */ int access$500() {
        return __MAX_SELECTS;
    }

    static /* synthetic */ int access$600() {
        return __JVMBUG_THRESHHOLD;
    }

    static /* synthetic */ int access$700() {
        return __BUSY_KEY;
    }

    static /* synthetic */ SelectSet[] access$800(SelectorManager selectorManager) {
        return selectorManager._selectSet;
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel selectableChannel, Object object) {
            this._channel = selectableChannel;
            this._attachment = object;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private volatile boolean _selecting;
        private transient int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;

        SelectSet(int n) throws Exception {
            this._setID = n;
            this._idleTimeout = new Timeout((Object)this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout((Object)this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object object) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(object);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel selectableChannel, Object object) {
            if (object == null) {
                this.addChange(selectableChannel);
            } else if (object instanceof EndPoint) {
                this.addChange(object);
            } else {
                this.addChange(new ChangeSelectableChannel(selectableChannel, object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doSelect() throws IOException {
            var1_1 = null;
            try {
                var4_2 = this._changes;
                synchronized (this._changes) {
                    block71: {
                        block73: {
                            block77: {
                                block76: {
                                    block74: {
                                        block75: {
                                            var2_5 = this._changes[this._change];
                                            this._change = this._change == 0 ? 1 : 0;
                                            this._selecting = true;
                                            var3_7 = this._selector;
                                            // ** MonitorExit[var4_2] (shouldn't be in output)
                                            for (var4_3 = 0; var4_3 < var2_5.size(); ++var4_3) {
                                                try {
                                                    var5_8 = var2_5.get(var4_3);
                                                    if (var5_8 instanceof EndPoint) {
                                                        var6_10 = (SelectChannelEndPoint)var5_8;
                                                        var6_10.doUpdateKey();
                                                        continue;
                                                    }
                                                    if (var5_8 instanceof Runnable) {
                                                        SelectorManager.this.dispatch((Runnable)var5_8);
                                                        continue;
                                                    }
                                                    if (var5_8 instanceof ChangeSelectableChannel) {
                                                        var6_10 = (ChangeSelectableChannel)var5_8;
                                                        var7_12 = var6_10._channel;
                                                        var8_13 = var6_10._attachment;
                                                        if (var7_12 instanceof SocketChannel && ((SocketChannel)var7_12).isConnected()) {
                                                            var1_1 = var7_12.register(var3_7, 1, var8_13);
                                                            var9_15 = SelectorManager.this.newEndPoint((SocketChannel)var7_12, this, var1_1);
                                                            var1_1.attach(var9_15);
                                                            var9_15.dispatch();
                                                            continue;
                                                        }
                                                        if (!var7_12.isOpen()) continue;
                                                        var7_12.register(var3_7, 8, var8_13);
                                                        continue;
                                                    }
                                                    if (var5_8 instanceof SocketChannel) {
                                                        var6_10 = (SocketChannel)var5_8;
                                                        if (var6_10.isConnected()) {
                                                            var1_1 = var6_10.register(var3_7, 1, null);
                                                            var7_12 = SelectorManager.this.newEndPoint((SocketChannel)var6_10, this, var1_1);
                                                            var1_1.attach(var7_12);
                                                            var7_12.dispatch();
                                                            continue;
                                                        }
                                                        if (!var6_10.isOpen()) continue;
                                                        var6_10.register(var3_7, 8, null);
                                                        continue;
                                                    }
                                                    if (var5_8 instanceof ServerSocketChannel) {
                                                        var6_10 = (ServerSocketChannel)var5_8;
                                                        var6_10.register(this.getSelector(), 16);
                                                        continue;
                                                    }
                                                    if (var5_8 instanceof ChangeTask == false) throw new IllegalArgumentException(var5_8.toString());
                                                    ((ChangeTask)var5_8).run();
                                                    continue;
                                                }
                                                catch (Exception var5_9) {
                                                    if (SelectorManager.this.isRunning()) {
                                                        Log.warn(var5_9);
                                                        continue;
                                                    }
                                                    Log.debug(var5_9);
                                                }
                                            }
                                            var2_5.clear();
                                            var4_4 = 0L;
                                            var6_11 = 0L;
                                            var8_14 = System.currentTimeMillis();
                                            var10_16 = this;
                                            synchronized (var10_16) {
                                                this._idleTimeout.setNow(var8_14);
                                                this._retryTimeout.setNow(var8_14);
                                                if (SelectorManager.access$100(SelectorManager.this) > 0L && (long)var3_7.keys().size() > SelectorManager.access$100(SelectorManager.this)) {
                                                    this._idleTimeout.setDuration(SelectorManager.access$200(SelectorManager.this));
                                                } else {
                                                    this._idleTimeout.setDuration(SelectorManager.access$300(SelectorManager.this));
                                                }
                                                var4_4 = this._idleTimeout.getTimeToNext();
                                                var6_11 = this._retryTimeout.getTimeToNext();
                                            }
                                            var10_17 = 1000L;
                                            if (var4_4 >= 0L && var10_17 > var4_4) {
                                                var10_17 = var4_4;
                                            }
                                            if (var10_17 > 0L && var6_11 >= 0L && var10_17 > var6_11) {
                                                var10_17 = var6_11;
                                            }
                                            if (var10_17 <= 2L) break block73;
                                            if (this._pausing) {
                                                try {
                                                    Thread.sleep(SelectorManager.access$400());
                                                }
                                                catch (InterruptedException var12_18) {
                                                    Log.ignore(var12_18);
                                                }
                                            }
                                            var12_19 = var8_14;
                                            var14_21 = var3_7.select(var10_17);
                                            var8_14 = System.currentTimeMillis();
                                            this._idleTimeout.setNow(var8_14);
                                            this._retryTimeout.setNow(var8_14);
                                            ++this._selects;
                                            if (var8_14 > this._monitorNext) {
                                                this._selects = (int)((long)(this._selects * SelectorManager.access$000()) / (var8_14 - this._monitorStart));
                                                v0 = this._pausing = this._selects > SelectorManager.access$500();
                                                if (this._pausing) {
                                                    ++this._paused;
                                                }
                                                this._selects = 0;
                                                this._jvmBug = 0;
                                                this._monitorStart = var8_14;
                                                this._monitorNext = var8_14 + (long)SelectorManager.access$000();
                                            }
                                            if (var8_14 > this._log) {
                                                if (this._paused > 0) {
                                                    Log.info(this + " Busy selector - injecting delay " + this._paused + " times");
                                                }
                                                if (this._jvmFix2 > 0) {
                                                    Log.info(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times");
                                                }
                                                if (this._jvmFix1 > 0) {
                                                    Log.info(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, canceled keys " + this._jvmFix0 + " times");
                                                } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                                                    Log.info(this + " JVM BUG(s) - canceled keys " + this._jvmFix0 + " times");
                                                }
                                                this._paused = 0;
                                                this._jvmFix2 = 0;
                                                this._jvmFix1 = 0;
                                                this._jvmFix0 = 0;
                                                this._log = var8_14 + 60000L;
                                            }
                                            if (var14_21 != 0 || var10_17 <= 10L || var8_14 - var12_19 >= var10_17 / 2L) break block74;
                                            ++this._jvmBug;
                                            if (this._jvmBug <= SelectorManager.access$600()) break block75;
                                            try {
                                                if (this._jvmBug == SelectorManager.access$600() + 1) {
                                                    ++this._jvmFix2;
                                                }
                                                Thread.sleep(SelectorManager.access$400());
                                            }
                                            catch (InterruptedException var15_23) {
                                                Log.ignore(var15_23);
                                            }
                                            break block71;
                                        }
                                        if (this._jvmBug != SelectorManager.access$600()) ** GOTO lbl-1000
                                        var15_24 = this;
                                        synchronized (var15_24) {
                                            ++this._jvmFix1;
                                            var16_30 = Selector.open();
                                            var17_34 = this._selector.keys().iterator();
                                            while (true) {
                                                if (!var17_34.hasNext()) {
                                                    this._selector.close();
                                                    this._selector = var16_30;
                                                    return;
                                                }
                                                var18_36 = var17_34.next();
                                                if (!var18_36.isValid() || var18_36.interestOps() == 0) continue;
                                                var19_37 = var18_36.channel();
                                                var20_38 = var18_36.attachment();
                                                if (var20_38 == null) {
                                                    this.addChange(var19_37);
                                                    continue;
                                                }
                                                this.addChange(var19_37, var20_38);
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            if (this._jvmBug % 32 != 31) break block71;
                                            var15_25 = 0;
                                            ** break block72
                                        }
                                    }
                                    if (SelectorManager.access$700() <= 0 || var14_21 != 1 || this._selects <= SelectorManager.access$500()) break block71;
                                    var15_26 = var3_7.selectedKeys().iterator().next();
                                    if (var15_26 != this._busyKey) break block76;
                                    if (++this._busyKeyCount > SelectorManager.access$700() && !(var15_26.channel() instanceof ServerSocketChannel)) {
                                        var16_32 = (SelectChannelEndPoint)var15_26.attachment();
                                        Log.warn("Busy Key " + var15_26.channel() + " " + var16_32);
                                        var15_26.cancel();
                                        if (var16_32 != null) {
                                            var16_32.close();
                                        }
                                    }
                                    break block77;
                                }
                                this._busyKeyCount = 0;
                            }
                            this._busyKey = var15_26;
                            break block71;
                        }
                        var3_7.selectNow();
                        ++this._selects;
                    }
                    if (this._selector == null) return;
                    if (!var3_7.isOpen()) {
                        return;
                    }
                    for (SelectionKey var1_1 : var3_7.selectedKeys()) {
                        try {
                            block79: {
                                block80: {
                                    block78: {
                                        if (!var1_1.isValid()) {
                                            var1_1.cancel();
                                            var13_39 = (SelectChannelEndPoint)var1_1.attachment();
                                            if (var13_39 == null) continue;
                                            var13_39.doUpdateKey();
                                            continue;
                                        }
                                        var13_39 = var1_1.attachment();
                                        if (!(var13_39 instanceof SelectChannelEndPoint)) break block78;
                                        var14_22 = (SelectChannelEndPoint)var13_39;
                                        var14_22.dispatch();
                                        break block79;
                                    }
                                    if (!var1_1.isAcceptable()) break block80;
                                    var14_22 = SelectorManager.this.acceptChannel(var1_1);
                                    if (var14_22 == null) continue;
                                    var14_22.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.access$800(SelectorManager.this).length;
                                    if (this._nextSet == this._setID) {
                                        var15_27 = var14_22.register(SelectorManager.access$800(SelectorManager.this)[this._nextSet].getSelector(), 1);
                                        var16_32 = SelectorManager.this.newEndPoint((SocketChannel)var14_22, SelectorManager.access$800(SelectorManager.this)[this._nextSet], var15_27);
                                        var15_27.attach(var16_32);
                                        if (var16_32 != null) {
                                            var16_32.dispatch();
                                        }
                                        break block79;
                                    } else {
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].addChange(var14_22);
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].wakeup();
                                    }
                                    break block79;
                                }
                                if (var1_1.isConnectable()) {
                                    var14_22 = (SocketChannel)var1_1.channel();
                                    var15_28 = false;
                                    try {
                                        var15_28 = var14_22.finishConnect();
                                    }
                                    catch (Exception var16_33) {
                                        SelectorManager.this.connectionFailed((SocketChannel)var14_22, var16_33, var13_39);
                                    }
                                    finally {
                                        if (var15_28) {
                                            var1_1.interestOps(1);
                                            var16_32 = SelectorManager.this.newEndPoint((SocketChannel)var14_22, this, var1_1);
                                            var1_1.attach(var16_32);
                                            var16_32.dispatch();
                                        } else {
                                            var1_1.cancel();
                                        }
                                    }
                                } else {
                                    var14_22 = (SocketChannel)var1_1.channel();
                                    var15_29 = SelectorManager.this.newEndPoint((SocketChannel)var14_22, this, var1_1);
                                    var1_1.attach(var15_29);
                                    if (var1_1.isReadable()) {
                                        var15_29.dispatch();
                                    }
                                }
                            }
                            var1_1 = null;
                        }
                        catch (CancelledKeyException var13_40) {
                            Log.ignore(var13_40);
                        }
                        catch (Exception var13_41) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn(var13_41);
                            } else {
                                Log.ignore(var13_41);
                            }
                            if (var1_1 == null || var1_1.channel() instanceof ServerSocketChannel || !var1_1.isValid()) continue;
                            var1_1.interestOps(0);
                            var1_1.cancel();
                        }
                    }
                    var3_7.selectedKeys().clear();
                    this._idleTimeout.tick(var8_14);
                    this._retryTimeout.tick(var8_14);
                    return;
                }
            }
            catch (CancelledKeyException var2_6) {
                Log.ignore(var2_6);
                return;
            }
lbl-1000:
            // 1 sources

            {
                for (SelectionKey var17_35 : var3_7.keys()) {
                    if (!var17_35.isValid() || var17_35.interestOps() != 0) continue;
                    var17_35.cancel();
                    ++var15_25;
                }
                if (var15_25 > 0) {
                    ++this._jvmFix0;
                }
                this._selecting = false;
                return;
            }
            finally {
                this._selecting = false;
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long l) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, l);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean bl = true;
            while (bl) {
                this.wakeup();
                bl = this._selecting;
            }
            ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>(this._selector.keys());
            for (SelectionKey object2 : arrayList) {
                Object iOException;
                if (object2 == null || !((iOException = object2.attachment()) instanceof EndPoint)) continue;
                EndPoint endPoint = (EndPoint)iOException;
                try {
                    endPoint.close();
                }
                catch (IOException iOException2) {
                    Log.ignore(iOException2);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                bl = this._selecting;
                while (bl) {
                    this.wakeup();
                    bl = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
                this._selector = null;
            }
        }
    }
}

