/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class RolloverFileOutputStream
extends FilterOutputStream {
    private static Timer __rollover;
    static final String YYYY_MM_DD = "yyyy_mm_dd";
    private RollTask _rollTask;
    private SimpleDateFormat _fileBackupFormat;
    private SimpleDateFormat _fileDateFormat;
    private String _filename;
    private File _file;
    private boolean _append;
    private int _retainDays;

    public RolloverFileOutputStream(String string) throws IOException {
        this(string, true, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    public RolloverFileOutputStream(String string, boolean bl) throws IOException {
        this(string, bl, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    public RolloverFileOutputStream(String string, boolean bl, int n) throws IOException {
        this(string, bl, n, TimeZone.getDefault());
    }

    public RolloverFileOutputStream(String string, boolean bl, int n, TimeZone timeZone) throws IOException {
        this(string, bl, n, timeZone, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RolloverFileOutputStream(String string, boolean bl, int n, TimeZone timeZone, String string2, String string3) throws IOException {
        super(null);
        if (string2 == null) {
            string2 = System.getProperty("ROLLOVERFILE_DATE_FORMAT", "yyyy_MM_dd");
        }
        this._fileDateFormat = new SimpleDateFormat(string2);
        if (string3 == null) {
            string3 = System.getProperty("ROLLOVERFILE_BACKUP_FORMAT", "HHmmssSSS");
        }
        this._fileBackupFormat = new SimpleDateFormat(string3);
        this._fileBackupFormat.setTimeZone(timeZone);
        this._fileDateFormat.setTimeZone(timeZone);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = string;
        this._append = bl;
        this._retainDays = n;
        this.setFile();
        Class<RolloverFileOutputStream> clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            if (__rollover == null) {
                __rollover = new Timer(true);
            }
            this._rollTask = new RollTask();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(timeZone);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 23, 0);
            gregorianCalendar.setTimeZone(timeZone);
            gregorianCalendar.add(10, 1);
            __rollover.scheduleAtFixedRate((TimerTask)this._rollTask, gregorianCalendar.getTime(), 86400000L);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    private synchronized void setFile() throws IOException {
        File file = new File(this._filename);
        this._filename = file.getCanonicalPath();
        file = new File(this._filename);
        File file2 = new File(file.getParent());
        if (!file2.isDirectory() || !file2.canWrite()) {
            throw new IOException("Cannot write log directory " + file2);
        }
        Date date = new Date();
        String string = file.getName();
        int n = string.toLowerCase().indexOf(YYYY_MM_DD);
        if (n >= 0) {
            file = new File(file2, string.substring(0, n) + this._fileDateFormat.format(date) + string.substring(n + YYYY_MM_DD.length()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot write log file " + file);
        }
        if (this.out == null || !file.equals(this._file)) {
            this._file = file;
            if (!this._append && file.exists()) {
                file.renameTo(new File(file.toString() + "." + this._fileBackupFormat.format(date)));
            }
            OutputStream outputStream = this.out;
            this.out = new FileOutputStream(file.toString(), this._append);
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void removeOldFiles() {
        if (this._retainDays > 0) {
            long l = System.currentTimeMillis();
            File file = new File(this._filename);
            File file2 = new File(file.getParent());
            String string = file.getName();
            int n = string.toLowerCase().indexOf(YYYY_MM_DD);
            if (n < 0) {
                return;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + YYYY_MM_DD.length());
            String[] stringArray = file2.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3;
                long l2;
                string = stringArray[i];
                if (!string.startsWith(string2) || string.indexOf(string3, string2.length()) < 0 || (l - (l2 = (file3 = new File(file2, string)).lastModified())) / 86400000L <= (long)this._retainDays) continue;
                file3.delete();
            }
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Class<RolloverFileOutputStream> clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            try {
                super.close();
            }
            finally {
                this.out = null;
                this._file = null;
            }
            this._rollTask.cancel();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class RollTask
    extends TimerTask {
        private RollTask() {
        }

        @Override
        public void run() {
            try {
                RolloverFileOutputStream.this.setFile();
                RolloverFileOutputStream.this.removeOldFiles();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

