/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.DelegateRecordReaderFactory;
import com.google.cloud.hadoop.io.bigquery.DynamicFileListRecordReader;
import com.google.cloud.hadoop.io.bigquery.Export;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.NoopFederatedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.QueryBasedExport;
import com.google.cloud.hadoop.io.bigquery.ShardedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import com.google.cloud.hadoop.io.bigquery.UnshardedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AbstractBigQueryInputFormat<K, V>
extends InputFormat<K, V>
implements DelegateRecordReaderFactory<K, V> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String INPUT_FORMAT_CLASS_KEY = "mapreduce.inputformat.class";
    public static final String EXTERNAL_TABLE_TYPE = "EXTERNAL";
    private InputFormat<LongWritable, Text> delegateInputFormat;

    public static void setInputTable(Configuration configuration, String projectId, String datasetId, String tableId) throws IOException {
        BigQueryConfiguration.configureBigQueryInput(configuration, projectId, datasetId, tableId);
    }

    public static void setInputTable(Configuration configuration, TableReference tableReference) throws IOException {
        AbstractBigQueryInputFormat.setInputTable(configuration, tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
    }

    public static void setTemporaryCloudStorageDirectory(Configuration configuration, String path) {
        configuration.set("mapred.bq.temp.gcs.path", path);
    }

    public static void setEnableShardedExport(Configuration configuration, boolean enabled) {
        configuration.setBoolean("mapred.bq.input.sharded.export.enable", enabled);
    }

    protected static boolean isShardedExportEnabled(Configuration configuration) {
        return configuration.getBoolean("mapred.bq.input.sharded.export.enable", false);
    }

    public abstract ExportFileFormat getExportFileFormat();

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        ((GoogleLogger.Api)logger.atFine()).log("getSplits(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)context)));
        Configuration configuration = context.getConfiguration();
        BigQueryHelper bigQueryHelper = null;
        try {
            bigQueryHelper = this.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
        String exportPath = BigQueryConfiguration.getTemporaryPathRoot(configuration, context.getJobID());
        configuration.set("mapred.bq.temp.gcs.path", exportPath);
        Export export = AbstractBigQueryInputFormat.constructExport(configuration, this.getExportFileFormat(), exportPath, bigQueryHelper, this.delegateInputFormat);
        export.prepare();
        try {
            export.beginExport();
            export.waitForUsableMapReduceInput();
        }
        catch (IOException | InterruptedException ie) {
            throw new IOException("Error while exporting", ie);
        }
        List<InputSplit> splits = export.getSplits(context);
        if (((GoogleLogger.Api)logger.atFine()).isEnabled()) {
            try {
                ((GoogleLogger.Api)logger.atFine()).log("getSplits -> %s", (Object)HadoopToStringUtil.toString(splits));
            }
            catch (InterruptedException e) {
                ((GoogleLogger.Api)logger.atFine()).log("getSplits -> %s", (Object)"*exception on toString()*");
            }
        }
        return splits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return this.createRecordReader(inputSplit, taskAttemptContext.getConfiguration());
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, Configuration configuration) throws IOException, InterruptedException {
        if (AbstractBigQueryInputFormat.isShardedExportEnabled(configuration)) {
            Preconditions.checkArgument((boolean)(inputSplit instanceof ShardedInputSplit), (Object)"Split should be instance of ShardedInputSplit.");
            ((GoogleLogger.Api)logger.atFine()).log("createRecordReader -> DynamicFileListRecordReader");
            return new DynamicFileListRecordReader(this);
        }
        Preconditions.checkArgument((boolean)(inputSplit instanceof UnshardedInputSplit), (Object)"Split should be instance of UnshardedInputSplit.");
        ((GoogleLogger.Api)logger.atFine()).log("createRecordReader -> createDelegateRecordReader()");
        return this.createDelegateRecordReader(inputSplit, configuration);
    }

    private static Export constructExport(Configuration configuration, ExportFileFormat format, String exportPath, BigQueryHelper bigQueryHelper, InputFormat delegateInputFormat) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("constructExport() with export path %s", (Object)exportPath);
        Map mandatoryConfig = ConfigurationUtil.getMandatoryConfig((Configuration)configuration, BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_INPUT);
        String jobProjectId = (String)mandatoryConfig.get("mapred.bq.project.id");
        String inputProjectId = (String)mandatoryConfig.get("mapred.bq.input.project.id");
        String datasetId = (String)mandatoryConfig.get("mapred.bq.input.dataset.id");
        String tableName = (String)mandatoryConfig.get("mapred.bq.input.table.id");
        TableReference exportTableReference = new TableReference().setDatasetId(datasetId).setProjectId(inputProjectId).setTableId(tableName);
        Table table = bigQueryHelper.getTable(exportTableReference);
        String query = configuration.get("mapred.bq.input.query");
        if (EXTERNAL_TABLE_TYPE.equals(table.getType())) {
            if (Strings.isNullOrEmpty((String)query)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Table is already external, so skipping export");
                AbstractBigQueryInputFormat.setEnableShardedExport(configuration, false);
                return new NoopFederatedExportToCloudStorage(configuration, format, bigQueryHelper, jobProjectId, table, (InputFormat<LongWritable, Text>)delegateInputFormat);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Ignoring use of federated data source, because a query was specified.");
        }
        boolean enableShardedExport = AbstractBigQueryInputFormat.isShardedExportEnabled(configuration);
        boolean deleteTableOnExit = configuration.getBoolean("mapred.bq.query.results.table.delete", false);
        ((GoogleLogger.Api)logger.atFine()).log("isShardedExportEnabled = %s, deleteTableOnExit = %s, tableReference = %s, query = %s", (Object)enableShardedExport, (Object)deleteTableOnExit, (Object)LazyArgs.lazy(() -> BigQueryStrings.toString(exportTableReference)), (Object)query);
        Export export = enableShardedExport ? new ShardedExportToCloudStorage(configuration, exportPath, format, bigQueryHelper, jobProjectId, table) : new UnshardedExportToCloudStorage(configuration, exportPath, format, bigQueryHelper, jobProjectId, table, (InputFormat<LongWritable, Text>)delegateInputFormat);
        if (!Strings.isNullOrEmpty((String)query)) {
            export = new QueryBasedExport(export, query, jobProjectId, bigQueryHelper, exportTableReference, deleteTableOnExit);
        }
        return export;
    }

    @Deprecated
    public static void cleanupJob(JobContext context) throws IOException {
        AbstractBigQueryInputFormat.cleanupJob(context.getConfiguration(), context.getJobID());
    }

    public static void cleanupJob(Configuration configuration, JobID jobId) throws IOException {
        String exportPathRoot = BigQueryConfiguration.getTemporaryPathRoot(configuration, jobId);
        configuration.set("mapred.bq.temp.gcs.path", exportPathRoot);
        Bigquery bigquery = null;
        try {
            bigquery = new BigQueryFactory().getBigQuery(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create Bigquery client", gse);
        }
        AbstractBigQueryInputFormat.cleanupJob(new BigQueryHelper(bigquery), configuration);
    }

    public static void cleanupJob(BigQueryHelper bigQueryHelper, Configuration config) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("cleanupJob(Bigquery, Configuration)");
        String gcsPath = ConfigurationUtil.getMandatoryConfig((Configuration)config, (String)"mapred.bq.temp.gcs.path");
        Export export = AbstractBigQueryInputFormat.constructExport(config, AbstractBigQueryInputFormat.getExportFileFormat(config), gcsPath, bigQueryHelper, null);
        try {
            export.cleanupExport();
        }
        catch (IOException ioe) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ioe)).log("Could not delete intermediate data from BigQuery export");
        }
    }

    protected static ExportFileFormat getExportFileFormat(Configuration configuration) {
        Class clazz = configuration.getClass(INPUT_FORMAT_CLASS_KEY, AbstractBigQueryInputFormat.class);
        Preconditions.checkState((boolean)AbstractBigQueryInputFormat.class.isAssignableFrom(clazz), (Object)"Expected input format to derive from AbstractBigQueryInputFormat");
        return AbstractBigQueryInputFormat.getExportFileFormat(clazz);
    }

    protected static ExportFileFormat getExportFileFormat(Class<? extends AbstractBigQueryInputFormat<?, ?>> clazz) {
        try {
            AbstractBigQueryInputFormat<?, ?> format = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return format.getExportFileFormat();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactory factory = new BigQueryFactory();
        return factory.getBigQuery(config);
    }

    protected BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactory factory = new BigQueryFactory();
        return factory.getBigQueryHelper(config);
    }

    @VisibleForTesting
    void setDelegateInputFormat(InputFormat inputFormat) {
        this.delegateInputFormat = inputFormat;
    }
}

