/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class AvroRecordReader
extends RecordReader<LongWritable, GenericData.Record> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    final LongWritable currentKey = new LongWritable();
    FileReader<GenericData.Record> dataFileReader;
    Schema schema;
    GenericData.Record currentRecord;
    long inputFileLength;
    long splitStart;
    long splitLength;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.initializeInternal(inputSplit, taskAttemptContext.getConfiguration());
    }

    protected void initializeInternal(InputSplit inputSplit, Configuration conf) throws IOException, InterruptedException {
        Preconditions.checkState((boolean)(inputSplit instanceof FileSplit), (Object)"AvroRecordReader requires FileSplit input splits.");
        FileSplit fileSplit = (FileSplit)inputSplit;
        this.splitStart = fileSplit.getStart();
        this.splitLength = fileSplit.getLength();
        Path filePath = fileSplit.getPath();
        FileSystem fs = filePath.getFileSystem(conf);
        FileStatus status = fs.getFileStatus(filePath);
        this.inputFileLength = status.getLen();
        final FSDataInputStream stream = fs.open(filePath);
        this.dataFileReader = DataFileReader.openReader((SeekableInput)new SeekableInput(){

            public void seek(long offset) throws IOException {
                stream.seek(offset);
            }

            public long tell() throws IOException {
                return stream.getPos();
            }

            public long length() throws IOException {
                return AvroRecordReader.this.inputFileLength;
            }

            public int read(byte[] bytes, int offset, int length) throws IOException {
                return stream.read(bytes, offset, length);
            }

            public void close() throws IOException {
                stream.close();
            }
        }, (DatumReader)new GenericDatumReader());
        this.dataFileReader.sync(fileSplit.getStart());
        this.schema = this.dataFileReader.getSchema();
        this.currentRecord = new GenericData.Record(this.schema);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        Preconditions.checkState((this.currentRecord != null ? 1 : 0) != 0);
        if (this.dataFileReader.hasNext() && !this.dataFileReader.pastSync(this.splitStart + this.splitLength)) {
            this.currentKey.set(this.currentKey.get() + 1L);
            this.dataFileReader.next((Object)this.currentRecord);
            return true;
        }
        return false;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public GenericData.Record getCurrentValue() throws IOException, InterruptedException {
        return this.currentRecord;
    }

    public float getProgress() throws IOException, InterruptedException {
        Preconditions.checkState((this.dataFileReader != null ? 1 : 0) != 0);
        if (this.splitLength == 0L) {
            return 1.0f;
        }
        float splitRelativeLocation = this.dataFileReader.tell() - this.splitStart;
        return splitRelativeLocation / (float)this.splitLength;
    }

    public void close() throws IOException {
        Preconditions.checkState((this.dataFileReader != null ? 1 : 0) != 0);
        this.dataFileReader.close();
    }
}

