/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.util.AccessTokenProviderClassFromConfigFactory;
import com.google.cloud.hadoop.util.CredentialFromAccessTokenProviderClassFactory;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;

public class BigQueryFactory {
    public static final String BIGQUERY_CONFIG_PREFIX = "mapred.bq";
    public static final ImmutableList<String> BIGQUERY_OAUTH_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/bigquery");
    public static final String BIGQUERY_SERVICE_ACCOUNT = "BIGQUERY_SERVICE_ACCOUNT";
    public static final String BIGQUERY_PRIVATE_KEY_FILE = "BIGQUERY_PRIVATE_KEY_FILE";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String PROPERTIES_FILE = "bigquery.properties";
    public static final String VERSION_PROPERTY = "bigquery.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION;
    public static final String BQC_ID;
    public static final BigQueryFactory INSTANCE;
    private static final HttpTransport HTTP_TRANSPORT;
    private static final JsonFactory JSON_FACTORY;

    public Credential createBigQueryCredential(Configuration config) throws GeneralSecurityException, IOException {
        Credential credential = CredentialFromAccessTokenProviderClassFactory.credential((AccessTokenProviderClassFromConfigFactory)new AccessTokenProviderClassFromConfigFactory().withOverridePrefix(BIGQUERY_CONFIG_PREFIX), (Configuration)config, BIGQUERY_OAUTH_SCOPES);
        if (credential != null) {
            return credential;
        }
        return ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix(BIGQUERY_CONFIG_PREFIX)).build()).getCredential(BIGQUERY_OAUTH_SCOPES);
    }

    public BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        return new BigQueryHelper(this.getBigQuery(config));
    }

    public Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
        ((GoogleLogger.Api)logger.atInfo()).log("Creating BigQuery from default credential.");
        Credential credential = this.createBigQueryCredential(config);
        return this.getBigQueryFromCredential(credential, BQC_ID);
    }

    public Bigquery getBigQueryFromCredential(Credential credential, String appName) {
        ((GoogleLogger.Api)logger.atInfo()).log("Creating BigQuery from given credential.");
        if (credential != null) {
            return new Bigquery.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)new RetryHttpInitializer(credential, appName)).setApplicationName(appName).build();
        }
        return new Bigquery.Builder(HTTP_TRANSPORT, JSON_FACTORY, null).setApplicationName(appName).build();
    }

    static {
        INSTANCE = new BigQueryFactory();
        VERSION = PropertyUtil.getPropertyOrDefault(BigQueryFactory.class, (String)PROPERTIES_FILE, (String)VERSION_PROPERTY, (String)UNKNOWN_VERSION);
        ((GoogleLogger.Api)logger.atInfo()).log("Bigquery connector version %s", (Object)VERSION);
        BQC_ID = String.format("Hadoop BigQuery Connector/%s", VERSION);
        HTTP_TRANSPORT = new NetHttpTransport();
        JSON_FACTORY = new JacksonFactory();
    }
}

