/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;

public class BigQueryOutputCommitter
extends OutputCommitter {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private String projectId;
    private TableReference tempTableRef;
    private TableReference finalTableRef;
    private BigQueryHelper bigQueryHelper;

    public BigQueryOutputCommitter(String projectId, TableReference tempTableRef, TableReference finalTableRef, Configuration configuration) throws IOException {
        this.projectId = projectId;
        this.tempTableRef = tempTableRef;
        this.finalTableRef = finalTableRef;
        try {
            BigQueryFactory bigQueryFactory = new BigQueryFactory();
            this.bigQueryHelper = bigQueryFactory.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not get Bigquery", e);
        }
    }

    public void setupJob(JobContext context) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("setupJob(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)context)));
        DatasetReference datasetReference = new DatasetReference();
        datasetReference.setProjectId(this.tempTableRef.getProjectId());
        datasetReference.setDatasetId(this.tempTableRef.getDatasetId());
        Dataset tempDataset = new Dataset();
        tempDataset.setDatasetReference(datasetReference);
        tempDataset.setLocation(this.getLocation(context));
        Bigquery.Datasets datasets = this.bigQueryHelper.getRawBigquery().datasets();
        ((GoogleLogger.Api)logger.atFine()).log("Creating temporary dataset '%s' for project '%s'", (Object)this.tempTableRef.getDatasetId(), (Object)this.tempTableRef.getProjectId());
        datasets.insert(this.tempTableRef.getProjectId(), tempDataset).execute();
    }

    public void cleanupJob(JobContext context) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("cleanupJob(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)context)));
        Bigquery.Datasets datasets = this.bigQueryHelper.getRawBigquery().datasets();
        try {
            ((GoogleLogger.Api)logger.atFine()).log("cleanupJob: Deleting dataset '%s' from project '%s'", (Object)this.tempTableRef.getDatasetId(), (Object)this.tempTableRef.getProjectId());
            datasets.delete(this.tempTableRef.getProjectId(), this.tempTableRef.getDatasetId()).setDeleteContents(Boolean.valueOf(true)).execute();
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Could not delete dataset. Temporary data not cleaned up.");
        }
    }

    public void abortJob(JobContext jobContext, int status) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("abortJob(%s, %s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)jobContext)), status);
        this.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("commitJob(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)jobContext)));
        this.cleanupJob(jobContext);
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("setupTask(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((TaskAttemptContext)context)));
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("commitTask(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((TaskAttemptContext)context)));
        JobConfigurationTableCopy copyTableConfig = new JobConfigurationTableCopy();
        copyTableConfig.setSourceTable(this.tempTableRef);
        copyTableConfig.setDestinationTable(this.finalTableRef);
        copyTableConfig.setWriteDisposition("WRITE_APPEND");
        JobConfiguration config = new JobConfiguration();
        config.setCopy(copyTableConfig);
        JobReference jobReference = this.bigQueryHelper.createJobReference(this.projectId, context.getTaskAttemptID().toString(), this.getLocation((JobContext)context));
        Job job = new Job();
        job.setConfiguration(config);
        job.setJobReference(jobReference);
        ((GoogleLogger.Api)logger.atFine()).log("commitTask: Running table copy from %s to %s", (Object)LazyArgs.lazy(() -> BigQueryStrings.toString(this.tempTableRef)), (Object)LazyArgs.lazy(() -> BigQueryStrings.toString(this.finalTableRef)));
        Job response = this.bigQueryHelper.insertJobOrFetchDuplicate(this.projectId, job);
        ((GoogleLogger.Api)logger.atFine()).log("Got response '%s'", (Object)response);
        try {
            BigQueryUtils.waitForJobCompletion(this.bigQueryHelper.getRawBigquery(), this.projectId, jobReference, (Progressable)context);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not check if results of task were transferred.", e);
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Saved output of task to table '%s' using project '%s'", (Object)BigQueryStrings.toString(this.finalTableRef), (Object)this.projectId);
    }

    public void abortTask(TaskAttemptContext context) {
        ((GoogleLogger.Api)logger.atFine()).log("abortTask(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((TaskAttemptContext)context)));
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.needsTaskCommit(context.getTaskAttemptID());
    }

    @VisibleForTesting
    public boolean needsTaskCommit(TaskAttemptID attemptId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("needsTaskCommit(%s) - tempTableRef: '%s'", (Object)attemptId, (Object)LazyArgs.lazy(() -> BigQueryStrings.toString(this.tempTableRef)));
        boolean tableExists = this.bigQueryHelper.tableExists(this.tempTableRef);
        ((GoogleLogger.Api)logger.atFine()).log("needsTaskCommit -> %s", (Object)tableExists);
        return tableExists;
    }

    @VisibleForTesting
    void setBigQueryHelper(BigQueryHelper helper) {
        this.bigQueryHelper = helper;
    }

    private String getLocation(JobContext context) {
        Configuration config = context.getConfiguration();
        return config.get("mapred.bq.output.location", "US");
    }
}

