/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryOutputCommitter;
import com.google.cloud.hadoop.io.bigquery.BigQueryRecordWriter;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;

@Deprecated
public class BigQueryOutputFormat<K, V extends JsonObject>
extends OutputFormat<K, V> {
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    public static final String TEMP_NAME = "_hadoop_temporary_";
    private static final GoogleLogger logger;

    public void checkOutputSpecs(JobContext context) throws IOException {
        ConfigurationUtil.getMandatoryConfig((Configuration)context.getConfiguration(), BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_OUTPUT);
        Preconditions.checkArgument((context.getConfiguration().getInt("mapred.bq.output.buffer.size", 0x4000000) >= 1 ? 1 : 0) != 0, (Object)"Output write buffer size should be a positive integer.");
    }

    public BigQueryOutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.getOutputCommitter(context.getConfiguration(), context.getTaskAttemptID());
    }

    @VisibleForTesting
    public BigQueryOutputCommitter getOutputCommitter(Configuration configuration, TaskAttemptID taskAttemptId) throws IOException, InterruptedException {
        ConfigurationUtil.getMandatoryConfig((Configuration)configuration, BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_OUTPUT);
        String projectId = configuration.get("mapred.bq.project.id");
        TableReference tempTableRef = BigQueryOutputFormat.getTempTableReference(configuration, taskAttemptId);
        TableReference finalTableRef = BigQueryOutputFormat.getFinalTableReference(configuration);
        ((GoogleLogger.Api)logger.atFine()).log("Returning BigQueryOutputCommitter('%s', '%s', '%s'", (Object)projectId, (Object)BigQueryStrings.toString(tempTableRef), (Object)BigQueryStrings.toString(finalTableRef));
        return new BigQueryOutputCommitter(projectId, tempTableRef, finalTableRef, configuration);
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        Map mandatoryConfig = ConfigurationUtil.getMandatoryConfig((Configuration)context.getConfiguration(), BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_OUTPUT);
        int writeBufferSize = context.getConfiguration().getInt("mapred.bq.output.buffer.size", 0x4000000);
        String jobProjectId = (String)mandatoryConfig.get("mapred.bq.project.id");
        String tableSchema = (String)mandatoryConfig.get("mapred.bq.output.table.schema");
        TableReference tempTableRef = BigQueryOutputFormat.getTempTableReference(context.getConfiguration(), context.getTaskAttemptID());
        ((GoogleLogger.Api)logger.atFine()).log("Returning new BigqueryRecordWriter for fields: '%s', project: '%s', table: '%s'", (Object)tableSchema, (Object)jobProjectId, (Object)BigQueryStrings.toString(tempTableRef));
        return new BigQueryRecordWriter(context.getConfiguration(), (Progressable)context, context.getTaskAttemptID().toString(), BigQueryUtils.getSchemaFromString(tableSchema), jobProjectId, tempTableRef, writeBufferSize);
    }

    static TableReference getFinalTableReference(Configuration configuration) {
        String outputProjectId = configuration.get("mapred.bq.output.project.id");
        String outputDatasetId = configuration.get("mapred.bq.output.dataset.id");
        String outputTableId = configuration.get("mapred.bq.output.table.id");
        TableReference finalTableRef = new TableReference().setProjectId(outputProjectId).setDatasetId(outputDatasetId).setTableId(outputTableId);
        return finalTableRef;
    }

    static TableReference getTempTableReference(Configuration configuration, TaskAttemptID taskAttemptId) {
        String outputProjectId = configuration.get("mapred.bq.output.project.id");
        String outputTableId = configuration.get("mapred.bq.output.table.id");
        String outputTempDatasetId = BigQueryOutputFormat.getTempDataset(configuration, taskAttemptId);
        String outputTempTable = BigQueryOutputFormat.getUniqueTable(taskAttemptId.toString(), outputTableId);
        TableReference tempTableRef = new TableReference().setProjectId(outputProjectId).setDatasetId(outputTempDatasetId).setTableId(outputTempTable);
        return tempTableRef;
    }

    static String getTempDataset(Configuration configuration, TaskAttemptID taskAttemptId) {
        return configuration.get("mapred.bq.output.dataset.id") + TEMP_NAME + taskAttemptId.getJobID().toString();
    }

    static String getUniqueTable(String taskAttemptId, String tableId) {
        return String.format("%s_%s", tableId.replace("$", "__"), taskAttemptId.toString());
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
        logger = GoogleLogger.forEnclosingClass();
    }
}

