/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.Progressable;

public class BigQueryUtils {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final int POLL_WAIT_INITIAL_MILLIS = (int)TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
    public static final int POLL_WAIT_INTERVAL_MAX_MILLIS = (int)TimeUnit.MILLISECONDS.convert(180L, TimeUnit.SECONDS);
    public static final int POLL_WAIT_MAX_ELAPSED_MILLIS = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);

    public static void waitForJobCompletion(Bigquery bigquery, String projectId, JobReference jobReference, Progressable progressable) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        ExponentialBackOff pollBackOff = new ExponentialBackOff.Builder().setMaxIntervalMillis(POLL_WAIT_INTERVAL_MAX_MILLIS).setInitialIntervalMillis(POLL_WAIT_INITIAL_MILLIS).setMaxElapsedTimeMillis(POLL_WAIT_MAX_ELAPSED_MILLIS).build();
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        boolean notDone = true;
        while (notDone) {
            ExponentialBackOff operationBackOff = new ExponentialBackOff.Builder().build();
            Bigquery.Jobs.Get get = bigquery.jobs().get(projectId, jobReference.getJobId()).setLocation(jobReference.getLocation());
            Job pollJob = (Job)ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)get), (BackOff)operationBackOff, (RetryDeterminer)RetryDeterminer.RATE_LIMIT_ERRORS, IOException.class, (Sleeper)sleeper);
            elapsedTime = System.currentTimeMillis() - startTime;
            ((GoogleLogger.Api)logger.atFine()).log("Job status (%s ms) %s: %s", (Object)elapsedTime, (Object)jobReference.getJobId(), (Object)pollJob.getStatus().getState());
            if (pollJob.getStatus().getState().equals("DONE")) {
                notDone = false;
                if (pollJob.getStatus().getErrorResult() == null) continue;
                throw new IOException("Error during BigQuery job execution: " + pollJob.getStatus().getErrorResult());
            }
            long millisToWait = pollBackOff.nextBackOffMillis();
            if (millisToWait == -1L) {
                throw new IOException(String.format("Job %s failed to complete after %s millis.", jobReference.getJobId(), elapsedTime));
            }
            Thread.sleep(millisToWait);
            progressable.progress();
        }
    }

    public static List<TableFieldSchema> getSchemaFromString(String fields) {
        ((GoogleLogger.Api)logger.atFine()).log("getSchemaFromString('%s')", (Object)fields);
        JsonParser jsonParser = new JsonParser();
        JsonArray json = jsonParser.parse(fields).getAsJsonArray();
        ArrayList<TableFieldSchema> fieldsList = new ArrayList<TableFieldSchema>();
        for (JsonElement jsonElement : json) {
            Preconditions.checkArgument((boolean)jsonElement.isJsonObject(), (String)"Expected JsonObject for element, got '%s'.", (Object)jsonElement);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Preconditions.checkArgument((jsonObject.get("name") != null ? 1 : 0) != 0, (String)"Expected non-null entry for key 'name' in JsonObject '%s'", (Object)jsonObject);
            Preconditions.checkArgument((jsonObject.get("type") != null ? 1 : 0) != 0, (String)"Expected non-null entry for key 'type' in JsonObject '%s'", (Object)jsonObject);
            TableFieldSchema fieldDef = new TableFieldSchema();
            fieldDef.setName(jsonObject.get("name").getAsString());
            fieldDef.setType(jsonObject.get("type").getAsString());
            if (jsonObject.get("mode") != null) {
                fieldDef.setMode(jsonObject.get("mode").getAsString());
            }
            if (jsonObject.get("type").getAsString().equals("RECORD")) {
                Preconditions.checkArgument((jsonObject.get("fields") != null ? 1 : 0) != 0, (String)"Expected non-null entry for key 'fields' in JsonObject of type RECORD: '%s'", (Object)jsonObject);
                fieldDef.setFields(BigQueryUtils.getSchemaFromString(jsonObject.get("fields").toString()));
            }
            fieldsList.add(fieldDef);
        }
        return fieldsList;
    }
}

