/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.io.bigquery.DelegateRecordReaderFactory;
import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class DynamicFileListRecordReader<K, V>
extends RecordReader<K, V> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private Path inputDirectoryAndPattern;
    private long estimatedNumRecords;
    private int pollIntervalMs;
    private TaskAttemptContext context;
    private FileSystem fileSystem;
    private Pattern exportPattern;
    private long recordsRead = 0L;
    private DelegateRecordReaderFactory<K, V> delegateRecordReaderFactory;
    private RecordReader<K, V> delegateReader = null;
    private Set<String> knownFileSet = new HashSet<String>();
    private Queue<FileStatus> fileQueue = new ArrayDeque<FileStatus>();
    private int endFileNumber = -1;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private K currentKey = null;
    private V currentValue = null;

    public DynamicFileListRecordReader(DelegateRecordReaderFactory<K, V> delegateRecordReaderFactory) {
        this.delegateRecordReaderFactory = delegateRecordReaderFactory;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        try {
            ((GoogleLogger.Api)logger.atInfo()).log("Initializing DynamicFileListRecordReader with split '%s', task context '%s'", (Object)HadoopToStringUtil.toString((InputSplit)genericSplit), (Object)HadoopToStringUtil.toString((TaskAttemptContext)context));
        }
        catch (InterruptedException ie) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ie)).log("InterruptedException when logging InputSplit.");
        }
        Preconditions.checkArgument((boolean)(genericSplit instanceof ShardedInputSplit), (Object)"InputSplit genericSplit should be an instance of ShardedInputSplit.");
        this.context = context;
        ShardedInputSplit shardedSplit = (ShardedInputSplit)genericSplit;
        this.inputDirectoryAndPattern = shardedSplit.getShardDirectoryAndPattern();
        this.estimatedNumRecords = shardedSplit.getLength();
        if (this.estimatedNumRecords <= 0L) {
            ((GoogleLogger.Api)logger.atWarning()).log("Non-positive estimatedNumRecords '%s'; clipping to 1.", this.estimatedNumRecords);
            this.estimatedNumRecords = 1L;
        }
        this.pollIntervalMs = context.getConfiguration().getInt("mapred.bq.dynamic.file.list.record.reader.poll.interval", 10000);
        this.fileSystem = this.inputDirectoryAndPattern.getFileSystem(context.getConfiguration());
        String exportPatternRegex = this.inputDirectoryAndPattern.getName().replace("*", "(\\d+)");
        this.exportPattern = Pattern.compile(exportPatternRegex);
        this.fileSystem.mkdirs(this.inputDirectoryAndPattern.getParent());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean needRefresh;
        this.currentValue = null;
        if (this.delegateReader != null) {
            if (this.delegateReader.nextKeyValue()) {
                this.populateCurrentKeyValue();
                return true;
            }
            this.delegateReader.close();
            this.delegateReader = null;
        }
        boolean bl = needRefresh = !this.isNextFileReady() && this.shouldExpectMoreFiles();
        while (needRefresh) {
            ((GoogleLogger.Api)logger.atFine()).log("No files available, but more are expected; refreshing...");
            this.refreshFileList();
            needRefresh = !this.isNextFileReady() && this.shouldExpectMoreFiles();
            if (!needRefresh) continue;
            ((GoogleLogger.Api)logger.atFine()).log("No new files found, sleeping before trying again...");
            try {
                this.sleeper.sleep((long)this.pollIntervalMs);
                this.context.progress();
            }
            catch (InterruptedException ie) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ie)).log("Interrupted while sleeping.");
            }
        }
        if (this.isNextFileReady()) {
            FileStatus newFile = this.moveToNextFile();
            ((GoogleLogger.Api)logger.atInfo()).log("Moving to next file '%s' which has %s bytes. Records read so far: %s", (Object)newFile.getPath(), (Object)newFile.getLen(), (Object)this.recordsRead);
            FileSplit split = new FileSplit(newFile.getPath(), 0L, newFile.getLen(), new String[0]);
            this.delegateReader = this.delegateRecordReaderFactory.createDelegateRecordReader((InputSplit)split, this.context.getConfiguration());
            this.delegateReader.initialize((InputSplit)split, this.context);
            if (!this.delegateReader.nextKeyValue()) {
                this.setEndFileMarkerFile(newFile.getPath().getName());
                return this.nextKeyValue();
            }
            this.populateCurrentKeyValue();
            return true;
        }
        Preconditions.checkState((!this.shouldExpectMoreFiles() ? 1 : 0) != 0, (Object)"Should not have exited the refresh loop shouldExpectMoreFiles = true and no files ready to read.");
        return false;
    }

    public K getCurrentKey() {
        return this.currentKey;
    }

    public V getCurrentValue() {
        return this.currentValue;
    }

    public float getProgress() {
        return Math.min(1.0f, (float)this.recordsRead / (float)this.estimatedNumRecords);
    }

    public void close() throws IOException {
        if (this.delegateReader != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Got non-null delegateReader during close(); possible premature close() call.");
            this.delegateReader.close();
            this.delegateReader = null;
        }
    }

    @VisibleForTesting
    void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    private void populateCurrentKeyValue() throws IOException, InterruptedException {
        this.currentKey = this.delegateReader.getCurrentKey();
        this.currentValue = this.delegateReader.getCurrentValue();
        ++this.recordsRead;
    }

    private boolean isNextFileReady() {
        return !this.fileQueue.isEmpty();
    }

    private FileStatus moveToNextFile() {
        return this.fileQueue.remove();
    }

    private boolean shouldExpectMoreFiles() {
        return this.endFileNumber == -1 || this.knownFileSet.size() <= this.endFileNumber;
    }

    private int parseFileIndex(String fileName) {
        Matcher match = null;
        String indexString = null;
        try {
            match = this.exportPattern.matcher(fileName);
            match.find();
            indexString = match.group(1);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to parse file '%s'", fileName), e);
        }
        long longValue = Long.parseLong(indexString);
        if (longValue > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(String.format("Invalid fileName '%s'; max allowable index is %d, got %d instead", fileName, Integer.MAX_VALUE, longValue));
        }
        return (int)longValue;
    }

    private void setEndFileMarkerFile(String fileName) {
        int fileIndex = this.parseFileIndex(fileName);
        if (this.endFileNumber == -1) {
            this.endFileNumber = fileIndex;
            ((GoogleLogger.Api)logger.atInfo()).log("Found end-marker file '%s' with index %s", (Object)fileName, this.endFileNumber);
            for (String knownFile : this.knownFileSet) {
                int knownFileIndex = this.parseFileIndex(knownFile);
                Preconditions.checkState((knownFileIndex <= this.endFileNumber ? 1 : 0) != 0, (String)"Found known file '%s' with index %s, which isn't less than or equal to than endFileNumber %s!", (Object)knownFile, (Object)knownFileIndex, (Object)this.endFileNumber);
            }
        } else {
            Preconditions.checkState((fileIndex == this.endFileNumber ? 1 : 0) != 0, (String)"Found new end-marker file '%s' with index %s but already have endFileNumber %s!", (Object)fileName, (Object)fileIndex, (Object)this.endFileNumber);
        }
    }

    private void refreshFileList() throws IOException {
        FileStatus[] files;
        for (FileStatus file : files = this.fileSystem.globStatus(this.inputDirectoryAndPattern)) {
            String fileName = file.getPath().getName();
            if (this.knownFileSet.contains(fileName)) continue;
            if (this.endFileNumber != -1) {
                int newFileIndex = this.parseFileIndex(fileName);
                Preconditions.checkState((newFileIndex < this.endFileNumber ? 1 : 0) != 0, (String)"Found new file '%s' with index %s, which isn't less than endFileNumber %s!", (Object)fileName, (Object)newFileIndex, (Object)this.endFileNumber);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Adding new file '%s' of size %s to knownFileSet.", (Object)fileName, file.getLen());
            this.knownFileSet.add(fileName);
            this.fileQueue.add(file);
        }
    }
}

