/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.AbstractExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class ShardedExportToCloudStorage
extends AbstractExportToCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String NUM_MAP_TASKS_HINT_KEY = "mapred.map.tasks";
    public static final int NUM_MAP_TASKS_HINT_DEFAULT = 2;
    public static final String MAX_EXPORT_SHARDS_KEY = "mapred.bq.input.sharded.export.shards.max";
    public static final int MAX_EXPORT_SHARDS_DEFAULT = 500;
    public static final long APPROXIMATE_EXPORT_FILE_SIZE = 0x10000000L;
    public static final int APPROXIMATE_MAX_EXPORT_FILES = 10000;
    public static final int MIN_SHARDS_FOR_SHARDED_EXPORT = 2;

    public ShardedExportToCloudStorage(Configuration configuration, String gcsPath, ExportFileFormat fileFormat, BigQueryHelper bigQueryHelper, String projectId, Table tableToExport) throws IOException {
        super(configuration, gcsPath, fileFormat, bigQueryHelper, projectId, tableToExport);
    }

    @Override
    public void waitForUsableMapReduceInput() throws IOException, InterruptedException {
        ((GoogleLogger.Api)logger.atFine()).log("Using sharded input. waitForUsableMapReduceInput is a no-op.");
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        long numTableRows = this.tableToExport.getNumRows().longValue();
        List<String> paths = this.getExportPaths();
        int pathCount = paths.size();
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (String exportPattern : paths) {
            splits.add(new ShardedInputSplit(new Path(exportPattern), Math.max(1L, numTableRows / (long)pathCount)));
        }
        return splits;
    }

    @Override
    public List<String> getExportPaths() throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        long numTableRows = this.tableToExport.getNumRows().longValue();
        long numTableBytes = this.tableToExport.getNumBytes();
        int numShards = this.computeNumShards(numTableBytes);
        ((GoogleLogger.Api)logger.atInfo()).log("Computed '%s' shards for sharded BigQuery export.", numShards);
        for (int i = 0; i < numShards; ++i) {
            String exportPattern = String.format("%s/shard-%d/%s", this.gcsPath, i, this.fileFormat.getFilePattern());
            paths.add(exportPattern);
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Table '%s' to be exported has %s rows and %s bytes", (Object)BigQueryStrings.toString(this.tableToExport.getTableReference()), (Object)numTableRows, (Object)numTableBytes);
        return paths;
    }

    private int computeNumShards(long numTableBytes) {
        int desiredNumMaps = this.configuration.getInt(NUM_MAP_TASKS_HINT_KEY, 2);
        ((GoogleLogger.Api)logger.atFine()).log("Fetched desiredNumMaps from '%s': %s", (Object)NUM_MAP_TASKS_HINT_KEY, desiredNumMaps);
        int estimatedNumFiles = (int)Math.min(numTableBytes / 0x10000000L, 10000L);
        ((GoogleLogger.Api)logger.atFine()).log("estimatedNumFiles: %s", estimatedNumFiles);
        int serviceMaxShards = this.configuration.getInt(MAX_EXPORT_SHARDS_KEY, 500);
        ((GoogleLogger.Api)logger.atFine()).log("Fetched serviceMaxShards from '%s': %s", (Object)MAX_EXPORT_SHARDS_KEY, serviceMaxShards);
        int numShards = Math.min(estimatedNumFiles, serviceMaxShards);
        if (numShards < desiredNumMaps) {
            ((GoogleLogger.Api)logger.atWarning()).log("Estimated number of shards < desired num maps (%s < %s); clipping to %s.", (Object)numShards, (Object)desiredNumMaps, (Object)numShards);
        } else {
            numShards = desiredNumMaps;
        }
        return Math.max(numShards, 2);
    }
}

