/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.AbstractExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Progressable;

public class UnshardedExportToCloudStorage
extends AbstractExportToCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private InputFormat<LongWritable, Text> delegateInputFormat;

    public UnshardedExportToCloudStorage(Configuration configuration, String gcsPath, ExportFileFormat fileFormat, BigQueryHelper bigQueryHelper, String projectId, Table tableToExport, @Nullable InputFormat<LongWritable, Text> delegateInputFormat) {
        super(configuration, gcsPath, fileFormat, bigQueryHelper, projectId, tableToExport);
        this.delegateInputFormat = delegateInputFormat == null ? new TextInputFormat() : delegateInputFormat;
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        ((GoogleLogger.Api)logger.atInfo()).log("Setting FileInputFormat's inputPath to '%s'", (Object)this.gcsPath);
        this.configuration.set("mapred.input.dir", this.gcsPath);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (InputSplit split : this.delegateInputFormat.getSplits(context)) {
            FileSplit fileSplit = (FileSplit)split;
            splits.add((InputSplit)new UnshardedInputSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations()));
        }
        return splits;
    }

    @Override
    public List<String> getExportPaths() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("Using unsharded splits");
        String exportPattern = this.gcsPath + "/" + this.fileFormat.getFilePattern();
        return ImmutableList.of((Object)exportPattern);
    }

    @Override
    public void waitForUsableMapReduceInput() throws IOException, InterruptedException {
        Preconditions.checkState((this.exportJobReference != null ? 1 : 0) != 0, (Object)"beginExport() must be called before waitForUsableMapReduceInput()");
        BigQueryUtils.waitForJobCompletion(this.bigQueryHelper.getRawBigquery(), this.projectId, this.exportJobReference, new Progressable(){

            public void progress() {
            }
        });
    }
}

