/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTimePartitioning;
import com.google.cloud.hadoop.io.bigquery.output.ForwardingBigQueryFileOutputCommitter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceStability.Unstable
public class IndirectBigQueryOutputCommitter
extends ForwardingBigQueryFileOutputCommitter {
    public IndirectBigQueryOutputCommitter(TaskAttemptContext context, OutputCommitter delegate) throws IOException {
        super(context, delegate);
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        super.commitJob(context);
        Configuration conf = context.getConfiguration();
        TableReference destTable = BigQueryOutputConfiguration.getTableReference(conf);
        String destProjectId = BigQueryOutputConfiguration.getProjectId(conf);
        String writeDisposition = BigQueryOutputConfiguration.getWriteDisposition(conf);
        Optional<BigQueryTableSchema> destSchema = BigQueryOutputConfiguration.getTableSchema(conf);
        Optional<BigQueryTimePartitioning> timePartitioning = BigQueryOutputConfiguration.getTablePartitioning(conf);
        String kmsKeyName = BigQueryOutputConfiguration.getKmsKeyName(conf);
        BigQueryFileFormat outputFileFormat = BigQueryOutputConfiguration.getFileFormat(conf);
        List<String> sourceUris = this.getOutputFileURIs();
        try {
            this.getBigQueryHelper().importFromGcs(destProjectId, destTable, destSchema.isPresent() ? destSchema.get().get() : null, timePartitioning.isPresent() ? timePartitioning.get().get() : null, kmsKeyName, outputFileFormat, writeDisposition, sourceUris, true);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to import GCS into BigQuery", e);
        }
        this.cleanup(context);
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        super.abortJob(context, state);
        this.cleanup(context);
    }
}

