/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfigurationProperty;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.EntriesCredentialConfiguration;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String MR_JOB_HISTORY_INTERMEDIATE_DONE_DIR_KEY = "mapreduce.jobhistory.intermediate-done-dir";
    public static final String MR_JOB_HISTORY_DONE_DIR_KEY = "mapreduce.jobhistory.done-dir";
    public static final GoogleHadoopFileSystemConfigurationProperty<String> PERMISSIONS_TO_REPORT = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.reported.permissions", "700", new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> BLOCK_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> AUTH_SERVICE_ACCOUNT_ENABLE = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.enable.service.account.auth");
    public static final GoogleHadoopFileSystemConfigurationProperty<String> AUTH_SERVICE_ACCOUNT_EMAIL = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.service.account.auth.email");
    public static final GoogleHadoopFileSystemConfigurationProperty<String> AUTH_SERVICE_ACCOUNT_KEY_FILE = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.service.account.auth.keyfile");
    public static final GoogleHadoopFileSystemConfigurationProperty<String> AUTH_CLIENT_ID = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.client.id");
    public static final GoogleHadoopFileSystemConfigurationProperty<String> AUTH_CLIENT_SECRET = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.client.secret");
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_PROJECT_ID = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.project.id");
    @Deprecated
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_SYSTEM_BUCKET = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.system.bucket");
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_CREATE_SYSTEM_BUCKET = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.system.bucket.create", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_WORKING_DIRECTORY = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<RequesterPaysOptions.RequesterPaysMode> GCS_REQUESTER_PAYS_MODE = new GoogleHadoopFileSystemConfigurationProperty<RequesterPaysOptions.RequesterPaysMode>("fs.gs.requester.pays.mode", RequesterPaysOptions.REQUESTER_PAYS_MODE_DEFAULT, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_REQUESTER_PAYS_PROJECT_ID = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.requester.pays.project.id");
    public static final GoogleHadoopFileSystemConfigurationProperty<Collection<String>> GCS_REQUESTER_PAYS_BUCKETS = new GoogleHadoopFileSystemConfigurationProperty<ImmutableList>("fs.gs.requester.pays.buckets", ImmutableList.of(), new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType> GCS_FILE_CHECKSUM_TYPE = new GoogleHadoopFileSystemConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType>("fs.gs.checksum.type", GoogleHadoopFileSystemBase.GcsFileChecksumType.NONE, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_FILE_SIZE_LIMIT_250GB = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.file.size.limit.250gb", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.performance.cache.enable", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.performance.cache.max.entry.age.ms", 5000L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.performance.cache.list.caching.enable", false, new String[0]);
    @Deprecated
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.performance.cache.dir.metadata.prefetch.limit", 1000L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_STATUS_PARALLEL_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.status.parallel.enable", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_PARENT_TIMESTAMP_UPDATE_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.parent.timestamp.update.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Collection<String>> GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES = new GoogleHadoopFileSystemConfigurationProperty<ImmutableList>("fs.gs.parent.timestamp.update.substrings.excludes", ImmutableList.of((Object)"/"), new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Collection<String>> GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES = new GoogleHadoopFileSystemConfigurationProperty<ImmutableList>("fs.gs.parent.timestamp.update.substrings.includes", ImmutableList.of((Object)"${mapreduce.jobhistory.intermediate-done-dir}", (Object)"${mapreduce.jobhistory.done-dir}"), new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_LAZY_INITIALIZATION_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.lazy.init.enable", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.implicit.dir.repair.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> PATH_CODEC = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.path.encoding", "uri-path", new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.implicit.dir.infer.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_FLAT_GLOB_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.glob.flatlist.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_CONCURRENT_GLOB_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.glob.concurrent.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_MARKER_FILE_CREATION_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.create.marker.files.enable", false, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new GoogleHadoopFileSystemConfigurationProperty("fs.gs.marker.file.pattern");
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_MAX_REQUESTS_PER_BATCH = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.max.requests.per.batch", 15L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_BATCH_THREADS = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.batch.threads", 15, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_COPY_MAX_REQUESTS_PER_BATCH = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.copy.max.requests.per.batch", 15L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_COPY_BATCH_THREADS = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.copy.batch.threads", 15, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_COPY_WITH_REWRITE_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.copy.with.rewrite.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_REWRITE_MAX_BYTES_PER_CALL = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.rewrite.max.bytes.per.call", 0x20000000L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_MAX_LIST_ITEMS_PER_CALL = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.list.max.items.per.call", 1024L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_HTTP_MAX_RETRY = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.http.max.retry", 10, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_HTTP_CONNECT_TIMEOUT = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.http.connect-timeout", 20000, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_HTTP_READ_TIMEOUT = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.http.read-timeout", 20000, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_PROXY_ADDRESS = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.proxy.address", EntriesCredentialConfiguration.PROXY_ADDRESS_DEFAULT, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_PROXY_USERNAME = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.proxy.username", EntriesCredentialConfiguration.PROXY_USERNAME_DEFAULT, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_PROXY_PASSWORD = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.proxy.password", EntriesCredentialConfiguration.PROXY_PASSWORD_DEFAULT, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<HttpTransportFactory.HttpTransportType> GCS_HTTP_TRANSPORT = new GoogleHadoopFileSystemConfigurationProperty<HttpTransportFactory.HttpTransportType>("fs.gs.http.transport.type", EntriesCredentialConfiguration.HTTP_TRANSPORT_DEFAULT, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_APPLICATION_NAME_SUFFIX = new GoogleHadoopFileSystemConfigurationProperty<String>("fs.gs.application.name.suffix", "", new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.max.wait.for.empty.object.creation.ms", 3000, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType> GCS_OUTPUT_STREAM_TYPE = new GoogleHadoopFileSystemConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType>("fs.gs.outputstream.type", GoogleHadoopFileSystemBase.OutputStreamType.BASIC, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_OUTPUT_STREAM_BUFFER_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.outputstream.buffer.size", 0x800000, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.outputstream.pipe.buffer.size", 0x100000, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.outputstream.upload.chunk.size", 0x4000000, "fs.gs.io.buffersize.write");
    public static final GoogleHadoopFileSystemConfigurationProperty<GoogleCloudStorageReadOptions.GenerationReadConsistency> GCS_GENERATION_READ_CONSISTENCY = new GoogleHadoopFileSystemConfigurationProperty<GoogleCloudStorageReadOptions.GenerationReadConsistency>("fs.gs.generation.read.consistency", GoogleCloudStorageReadOptions.DEFAULT_GENERATION_READ_CONSISTENCY, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_INPUT_STREAM_BUFFER_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.inputstream.buffer.size", 0, "fs.gs.io.buffersize");
    public static final GoogleHadoopFileSystemConfigurationProperty<Boolean> GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE = new GoogleHadoopFileSystemConfigurationProperty<Boolean>("fs.gs.inputstream.fast.fail.on.not.found.enable", true, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new GoogleHadoopFileSystemConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", 0x800000L, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise> GCS_INPUT_STREAM_FADVISE = new GoogleHadoopFileSystemConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise>("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.Fadvise.AUTO, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<Integer> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new GoogleHadoopFileSystemConfigurationProperty<Integer>("fs.gs.inputstream.min.range.request.size", 524288, new String[0]);
    public static final GoogleHadoopFileSystemConfigurationProperty<String> GCS_CONFIG_OVERRIDE_FILE = new GoogleHadoopFileSystemConfigurationProperty<Object>("fs.gs.config.override.file", null, new String[0]);

    static GoogleCloudStorageFileSystemOptions.Builder getGcsFsOptionsBuilder(Configuration config) {
        GoogleCloudStorageFileSystemOptions.Builder gcsFsOptionsBuilder = GoogleCloudStorageFileSystemOptions.newBuilder().setEnableBucketDelete(GCE_BUCKET_DELETE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setShouldIncludeInTimestampUpdatesPredicate((GoogleCloudStorageFileSystemOptions.TimestampUpdatePredicate)GoogleHadoopFileSystemBase.ParentTimestampUpdateIncludePredicate.create(config)).setMarkerFilePattern(GCS_MARKER_FILE_PATTERN.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setIsPerformanceCacheEnabled(GCS_PERFORMANCE_CACHE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setImmutablePerformanceCachingOptions(GoogleHadoopFileSystemConfiguration.getPerformanceCachingOptions(config)).setStatusParallelEnabled(GCS_STATUS_PARALLEL_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue());
        String projectId = GCS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        gcsFsOptionsBuilder.getCloudStorageOptionsBuilder().setAutoRepairImplicitDirectoriesEnabled(GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setInferImplicitDirectoriesEnabled(GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setMarkerFileCreationEnabled(GCS_MARKER_FILE_CREATION_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setCopyWithRewriteEnabled(GCS_COPY_WITH_REWRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setMaxBytesRewrittenPerCall(GCS_REWRITE_MAX_BYTES_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setCopyMaxRequestsPerBatch(GCS_COPY_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setCopyBatchThreads(GCS_COPY_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setTransportType(GCS_HTTP_TRANSPORT.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProxyAddress(GCS_PROXY_ADDRESS.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyUsername(GCS_PROXY_USERNAME.getPassword(config)).setProxyPassword(GCS_PROXY_PASSWORD.getPassword(config)).setProjectId(projectId).setMaxListItemsPerCall(GCS_MAX_LIST_ITEMS_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setMaxRequestsPerBatch(GCS_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setBatchThreads(GCS_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setMaxHttpRequestRetries(GCS_HTTP_MAX_RETRY.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setHttpRequestConnectTimeout(GCS_HTTP_CONNECT_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setHttpRequestReadTimeout(GCS_HTTP_READ_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setAppName(GoogleHadoopFileSystemConfiguration.getApplicationName(config)).setMaxWaitMillisForEmptyObjectCreation(GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setReadChannelOptions(GoogleHadoopFileSystemConfiguration.getReadChannelOptions(config)).setWriteChannelOptions(GoogleHadoopFileSystemConfiguration.getWriteChannelOptions(config)).setRequesterPaysOptions(GoogleHadoopFileSystemConfiguration.getRequesterPaysOptions(config, projectId));
        return gcsFsOptionsBuilder;
    }

    private static PerformanceCachingGoogleCloudStorageOptions getPerformanceCachingOptions(Configuration config) {
        return PerformanceCachingGoogleCloudStorageOptions.builder().setMaxEntryAgeMillis(GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setListCachingEnabled(GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).build();
    }

    private static String getApplicationName(Configuration config) {
        String appNameSuffix = Strings.nullToEmpty((String)GCS_APPLICATION_NAME_SUFFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        String applicationName = GoogleHadoopFileSystem.GHFS_ID + appNameSuffix;
        ((GoogleLogger.Api)logger.atFine()).log("Setting GCS application name to %s", (Object)applicationName);
        return applicationName;
    }

    private static GoogleCloudStorageReadOptions getReadChannelOptions(Configuration config) {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setInplaceSeekLimit(GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1)).longValue()).setBufferSize(GCS_INPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setFadvise(GCS_INPUT_STREAM_FADVISE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setMinRangeRequestSize(GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setGenerationReadConsistency(GCS_GENERATION_READ_CONSISTENCY.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).build();
    }

    private static AsyncWriteChannelOptions getWriteChannelOptions(Configuration config) {
        return AsyncWriteChannelOptions.newBuilder().setFileSizeLimitedTo250Gb(GCS_FILE_SIZE_LIMIT_250GB.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()).setBufferSize(GCS_OUTPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setPipeBufferSize(GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).setUploadChunkSize(GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1)).intValue()).build();
    }

    private static RequesterPaysOptions getRequesterPaysOptions(Configuration config, String projectId) {
        String requesterPaysProjectId = GCS_REQUESTER_PAYS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return RequesterPaysOptions.builder().setMode(GCS_REQUESTER_PAYS_MODE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProjectId(requesterPaysProjectId == null ? projectId : requesterPaysProjectId).setBuckets(GCS_REQUESTER_PAYS_BUCKETS.getStringCollection(config)).build();
    }
}

