/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.CloudSqlInstance;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public final class CoreSocketFactory {
    public static final String CLOUD_SQL_INSTANCE_PROPERTY = "cloudSqlInstance";
    public static final String MYSQL_SOCKET_FILE_FORMAT = "/cloudsql/%s";
    public static final String POSTGRES_SOCKET_FILE_FORMAT = "/cloudsql/%s/.s.PGSQL.5432";
    @Deprecated
    public static final String USER_TOKEN_PROPERTY_NAME = "_CLOUD_SQL_USER_TOKEN";
    private static final Logger logger = Logger.getLogger(CoreSocketFactory.class.getName());
    private static final String DEFAULT_IP_TYPES = "PUBLIC,PRIVATE";
    static final String ADMIN_API_NOT_ENABLED_REASON = "accessNotConfigured";
    static final String INSTANCE_NOT_AUTHORIZED_REASON = "notAuthorized";
    private static final String API_ROOT_URL_PROPERTY = "_CLOUD_SQL_API_ROOT_URL";
    private static final String API_SERVICE_PATH_PROPERTY = "_CLOUD_SQL_API_SERVICE_PATH";
    private static final int DEFAULT_SERVER_PROXY_PORT = 3307;
    private static final int RSA_KEY_SIZE = 2048;
    private static CoreSocketFactory coreSocketFactory;
    private final CertificateFactory certificateFactory;
    private final KeyPair localKeyPair;
    private final Credential credential;
    private final ConcurrentHashMap<String, CloudSqlInstance> instances = new ConcurrentHashMap();
    private final ListeningScheduledExecutorService executor;
    private final SQLAdmin adminApi;
    private final int serverProxyPort;

    @VisibleForTesting
    CoreSocketFactory(KeyPair localKeyPair, Credential credential, SQLAdmin adminApi, int serverProxyPort) {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException err) {
            throw new RuntimeException("X509 implementation not available", err);
        }
        this.localKeyPair = localKeyPair;
        this.credential = credential;
        this.adminApi = adminApi;
        this.serverProxyPort = serverProxyPort;
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(2);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor));
    }

    public static synchronized CoreSocketFactory getInstance() {
        if (coreSocketFactory == null) {
            CredentialFactory credentialFactory;
            logger.info("First Cloud SQL connection, generating RSA key pair.");
            KeyPair keyPair = CoreSocketFactory.generateRsaKeyPair();
            if (System.getProperty("cloudSql.socketFactory.credentialFactory") != null) {
                try {
                    credentialFactory = (CredentialFactory)Class.forName(System.getProperty("cloudSql.socketFactory.credentialFactory")).newInstance();
                }
                catch (Exception err) {
                    throw new RuntimeException(err);
                }
            } else {
                credentialFactory = new ApplicationDefaultCredentialFactory();
            }
            Credential credential = credentialFactory.create();
            SQLAdmin adminApi = CoreSocketFactory.createAdminApiClient((HttpRequestInitializer)credential);
            coreSocketFactory = new CoreSocketFactory(keyPair, credential, adminApi, 3307);
        }
        return coreSocketFactory;
    }

    public static Socket connect(Properties props, String socketPathFormat) throws IOException {
        String csqlInstanceName = props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        List<String> ipTypes = CoreSocketFactory.listIpTypes(props.getProperty("ipTypes", DEFAULT_IP_TYPES));
        boolean forceUnixSocket = System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null;
        Preconditions.checkArgument((csqlInstanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        if (forceUnixSocket || CoreSocketFactory.runningOnGaeStandard() || CoreSocketFactory.runningOnGoogleCloudFunctions()) {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket.", csqlInstanceName));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(String.format(socketPathFormat, csqlInstanceName)));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        logger.info(String.format("Connecting to Cloud SQL instance [%s] via SSL socket.", csqlInstanceName));
        return CoreSocketFactory.getInstance().createSslSocket(csqlInstanceName, ipTypes);
    }

    private static boolean runningOnGaeStandard() {
        String gaeEnv = System.getenv("GAE_ENV");
        String runEnv = System.getProperty("com.google.appengine.runtime.environment");
        String gaeRuntime = System.getenv("GAE_RUNTIME");
        return "standard".equals(gaeEnv) && ("Production".equals(runEnv) || "java11".equals(gaeRuntime));
    }

    private static boolean runningOnGoogleCloudFunctions() {
        return System.getenv("K_SERVICE") != null && System.getenv("K_REVISION") != null;
    }

    @VisibleForTesting
    Socket createSslSocket(String instanceName, List<String> ipTypes) throws IOException {
        CloudSqlInstance instance = this.instances.computeIfAbsent(instanceName, k -> new CloudSqlInstance((String)k, this.adminApi, this.executor, this.localKeyPair));
        try {
            SSLSocket socket = instance.createSslSocket();
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            String instanceIp = instance.getPreferredIp(ipTypes);
            socket.connect(new InetSocketAddress(instanceIp, this.serverProxyPort));
            socket.startHandshake();
            return socket;
        }
        catch (Exception ex) {
            instance.forceRefresh();
            throw ex;
        }
    }

    private static void logTestPropertyWarning(String property) {
        logger.warning(String.format("%s is a test property and may be changed or removed in a future version without notice.", property));
    }

    private static List<String> listIpTypes(String cloudSqlIpTypes) {
        String[] rawTypes = cloudSqlIpTypes.split(",");
        ArrayList<String> result = new ArrayList<String>(rawTypes.length);
        for (int i = 0; i < rawTypes.length; ++i) {
            if (rawTypes[i].trim().equalsIgnoreCase("PUBLIC")) {
                result.add(i, "PRIMARY");
                continue;
            }
            result.add(i, rawTypes[i].trim().toUpperCase());
        }
        return result;
    }

    @Nullable
    private String getCredentialServiceAccount(Credential credential) {
        return credential instanceof GoogleCredential ? ((GoogleCredential)credential).getServiceAccountId() : null;
    }

    private static SQLAdmin createAdminApiClient(HttpRequestInitializer requestInitializer) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException err) {
            throw new RuntimeException("Unable to initialize HTTP transport", err);
        }
        String rootUrl = System.getProperty(API_ROOT_URL_PROPERTY);
        String servicePath = System.getProperty(API_SERVICE_PATH_PROPERTY);
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        SQLAdmin.Builder adminApiBuilder = new SQLAdmin.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, requestInitializer).setApplicationName(CoreSocketFactory.getApplicationName());
        if (rootUrl != null) {
            CoreSocketFactory.logTestPropertyWarning(API_ROOT_URL_PROPERTY);
            adminApiBuilder.setRootUrl(rootUrl);
        }
        if (servicePath != null) {
            CoreSocketFactory.logTestPropertyWarning(API_SERVICE_PATH_PROPERTY);
            adminApiBuilder.setServicePath(servicePath);
        }
        return adminApiBuilder.build();
    }

    private static KeyPair generateRsaKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException("Unable to initialize Cloud SQL socket factory because no RSA implementation is available.");
        }
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    public static void setApplicationName(String applicationName) {
        if (coreSocketFactory != null) {
            throw new IllegalStateException("Unable to set ApplicationName - SQLAdmin client already initialized.");
        }
        System.setProperty(USER_TOKEN_PROPERTY_NAME, applicationName);
    }

    public static String getApplicationName() {
        if (coreSocketFactory != null) {
            return CoreSocketFactory.coreSocketFactory.adminApi.getApplicationName();
        }
        return System.getProperty(USER_TOKEN_PROPERTY_NAME, "Cloud SQL Java Socket Factory");
    }

    private static class ApplicationDefaultCredentialFactory
    implements CredentialFactory {
        private ApplicationDefaultCredentialFactory() {
        }

        @Override
        public Credential create() {
            GoogleCredential credential;
            try {
                credential = GoogleCredential.getApplicationDefault();
            }
            catch (IOException err) {
                throw new RuntimeException("Unable to obtain credentials to communicate with the Cloud SQL API", err);
            }
            if (credential.createScopedRequired()) {
                credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/sqlservice.admin"));
            }
            return credential;
        }
    }
}

