/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.AuthType;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.AccessTokenSupplier;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.DefaultAccessTokenSupplier;
import com.google.cloud.sql.core.InstanceData;
import com.google.cloud.sql.core.InstanceDataSupplier;
import com.google.cloud.sql.core.RefreshCalculator;
import com.google.cloud.sql.core.SslData;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.security.KeyPair;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;

class CloudSqlInstance {
    private static final Logger logger = Logger.getLogger(CloudSqlInstance.class.getName());
    private final ListeningScheduledExecutorService executor;
    private final InstanceDataSupplier instanceDataSupplier;
    private final AuthType authType;
    private final AccessTokenSupplier accessTokenSupplier;
    private final CloudSqlInstanceName instanceName;
    private final ListenableFuture<KeyPair> keyPair;
    private final Object instanceDataGuard = new Object();
    private final RateLimiter forcedRenewRateLimiter;
    private final RefreshCalculator refreshCalculator = new RefreshCalculator();
    @GuardedBy(value="instanceDataGuard")
    private ListenableFuture<InstanceData> currentInstanceData;
    @GuardedBy(value="instanceDataGuard")
    private ListenableFuture<InstanceData> nextInstanceData;
    @GuardedBy(value="instanceDataGuard")
    private boolean forceRefreshRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloudSqlInstance(String connectionName, InstanceDataSupplier instanceDataSupplier, AuthType authType, CredentialFactory tokenSourceFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> keyPair, RateLimiter forcedRenewRateLimiter) {
        this.instanceName = new CloudSqlInstanceName(connectionName);
        this.instanceDataSupplier = instanceDataSupplier;
        this.authType = authType;
        this.executor = executor;
        this.keyPair = keyPair;
        this.forcedRenewRateLimiter = forcedRenewRateLimiter;
        this.accessTokenSupplier = authType == AuthType.IAM ? new DefaultAccessTokenSupplier(tokenSourceFactory) : Optional::empty;
        Object object = this.instanceDataGuard;
        synchronized (object) {
            this.currentInstanceData = executor.submit(this::performRefresh);
            this.nextInstanceData = this.currentInstanceData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceData getInstanceData() {
        ListenableFuture<InstanceData> instanceDataFuture;
        Object object = this.instanceDataGuard;
        synchronized (object) {
            instanceDataFuture = this.currentInstanceData;
        }
        try {
            return (InstanceData)Uninterruptibles.getUninterruptibly(instanceDataFuture);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }

    SSLSocket createSslSocket() throws IOException {
        return (SSLSocket)this.getInstanceData().getSslContext().getSocketFactory().createSocket();
    }

    String getPreferredIp(List<String> preferredTypes) {
        Map<String, String> ipAddrs = this.getInstanceData().getIpAddrs();
        for (String ipType : preferredTypes) {
            String preferredIp = ipAddrs.get(ipType);
            if (preferredIp == null) continue;
            return preferredIp;
        }
        throw new IllegalArgumentException(String.format("[%s] Cloud SQL instance  does not have any IP addresses matching preferences (%s)", this.instanceName.getConnectionName(), String.join((CharSequence)", ", preferredTypes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRefresh() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            if (this.forceRefreshRunning) {
                return;
            }
            this.forceRefreshRunning = true;
            this.nextInstanceData.cancel(false);
            logger.fine(String.format("[%s] Force Refresh: the next refresh operation was cancelled. Scheduling new refresh operation immediately.", this.instanceName));
            this.nextInstanceData = this.executor.submit(this::performRefresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceData performRefresh() throws InterruptedException, ExecutionException {
        logger.fine(String.format("[%s] Refresh Operation: Acquiring rate limiter permit.", this.instanceName));
        this.forcedRenewRateLimiter.acquire();
        logger.fine(String.format("[%s] Refresh Operation: Acquired rate limiter permit. Starting refresh...", this.instanceName));
        try {
            InstanceData data = this.instanceDataSupplier.getInstanceData(this.instanceName, this.accessTokenSupplier, this.authType, this.executor, this.keyPair);
            logger.fine(String.format("[%s] Refresh Operation: Completed refresh with new certificate expiration at %s.", this.instanceName, data.getExpiration().toInstant().toString()));
            long secondsToRefresh = this.refreshCalculator.calculateSecondsUntilNextRefresh(Instant.now(), data.getExpiration().toInstant());
            logger.fine(String.format("[%s] Refresh Operation: Next operation scheduled at %s.", this.instanceName, Instant.now().plus(secondsToRefresh, ChronoUnit.SECONDS).truncatedTo(ChronoUnit.SECONDS).toString()));
            Object object = this.instanceDataGuard;
            synchronized (object) {
                this.currentInstanceData = Futures.immediateFuture((Object)data);
                this.nextInstanceData = this.executor.schedule(this::performRefresh, secondsToRefresh, TimeUnit.SECONDS);
                this.forceRefreshRunning = false;
            }
            return data;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.FINE, String.format("[%s] Refresh Operation: Failed! Starting next refresh operation immediately.", this.instanceName), e);
            Object object = this.instanceDataGuard;
            synchronized (object) {
                this.nextInstanceData = this.executor.submit(this::performRefresh);
            }
            throw e;
        }
    }

    SslData getSslData() {
        return this.getInstanceData().getSslData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<InstanceData> getNext() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            return this.nextInstanceData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<InstanceData> getCurrent() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            return this.currentInstanceData;
        }
    }

    public CloudSqlInstanceName getInstanceName() {
        return this.instanceName;
    }
}

