/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.cloud.sql.core.ApiFetcherFactory;
import com.google.cloud.sql.core.SqlAdminApiFetcher;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class SqlAdminApiFetcherFactory
implements ApiFetcherFactory {
    private static final String API_ROOT_URL_PROPERTY = "_CLOUD_SQL_API_ROOT_URL";
    private static final String API_SERVICE_PATH_PROPERTY = "_CLOUD_SQL_API_SERVICE_PATH";
    private final String rootUrl;
    private final String servicePath;
    private final String userAgents;

    public SqlAdminApiFetcherFactory(String userAgents) {
        this.userAgents = userAgents;
        this.rootUrl = System.getProperty(API_ROOT_URL_PROPERTY);
        this.servicePath = System.getProperty(API_SERVICE_PATH_PROPERTY);
    }

    @Override
    public SqlAdminApiFetcher create(HttpRequestInitializer requestInitializer) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException err) {
            throw new RuntimeException("Unable to initialize HTTP transport", err);
        }
        GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
        SQLAdmin.Builder adminApiBuilder = new SQLAdmin.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, requestInitializer).setApplicationName(this.userAgents);
        if (this.rootUrl != null) {
            adminApiBuilder.setRootUrl(this.rootUrl);
        }
        if (this.servicePath != null) {
            adminApiBuilder.setServicePath(this.servicePath);
        }
        return new SqlAdminApiFetcher(adminApiBuilder.build());
    }
}

