/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;

public interface CredentialFactory {
    public static final String CREDENTIAL_FACTORY_PROPERTY = "cloudSql.socketFactory.credentialFactory";

    public HttpRequestInitializer create();

    default public GoogleCredentials getCredentials() {
        HttpRequestInitializer requestInitializer = this.create();
        if (requestInitializer instanceof HttpCredentialsAdapter) {
            HttpCredentialsAdapter adapter = (HttpCredentialsAdapter)requestInitializer;
            Credentials c = adapter.getCredentials();
            if (c instanceof GoogleCredentials) {
                return (GoogleCredentials)c;
            }
            throw new RuntimeException(String.format("Unable to determine GoogleCredential from HttpRequestInitializer: HttpCredentialsAdapter did not create valid credentials. %s, %s", requestInitializer.getClass().getName(), c));
        }
        if (requestInitializer instanceof Credential) {
            final Credential credential = (Credential)requestInitializer;
            AccessToken accessToken = new AccessToken(credential.getAccessToken(), credential.getExpirationTimeMilliseconds() != null ? Date.from(Instant.ofEpochMilli(credential.getExpirationTimeMilliseconds())) : null);
            return new GoogleCredentials(accessToken){

                public AccessToken refreshAccessToken() throws IOException {
                    credential.refreshToken();
                    return new AccessToken(credential.getAccessToken(), credential.getExpirationTimeMilliseconds() != null ? Date.from(Instant.ofEpochMilli(credential.getExpirationTimeMilliseconds())) : null);
                }
            };
        }
        throw new RuntimeException(String.format("Unable to determine GoogleCredential from HttpRequestInitializer: Unsupported credentials of type %s", requestInitializer.getClass().getName()));
    }
}

