/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.AuthType;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.AccessTokenSupplier;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.DefaultAccessTokenSupplier;
import com.google.cloud.sql.core.InstanceData;
import com.google.cloud.sql.core.InstanceDataSupplier;
import com.google.cloud.sql.core.RefreshCalculator;
import com.google.cloud.sql.core.SslData;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.RateLimiter;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.security.KeyPair;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;

class CloudSqlInstance {
    private static final Logger logger = Logger.getLogger(CloudSqlInstance.class.getName());
    private final ListeningScheduledExecutorService executor;
    private final InstanceDataSupplier instanceDataSupplier;
    private final AuthType authType;
    private final AccessTokenSupplier accessTokenSupplier;
    private final CloudSqlInstanceName instanceName;
    private final ListenableFuture<KeyPair> keyPair;
    private final Object instanceDataGuard = new Object();
    private final RateLimiter forcedRenewRateLimiter;
    private final RefreshCalculator refreshCalculator = new RefreshCalculator();
    @GuardedBy(value="instanceDataGuard")
    private ListenableFuture<InstanceData> currentInstanceData;
    @GuardedBy(value="instanceDataGuard")
    private ListenableFuture<InstanceData> nextInstanceData;
    @GuardedBy(value="instanceDataGuard")
    private boolean refreshRunning;
    @GuardedBy(value="instanceDataGuard")
    private Throwable currentRefreshFailure;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloudSqlInstance(String connectionName, InstanceDataSupplier instanceDataSupplier, AuthType authType, CredentialFactory tokenSourceFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> keyPair, RateLimiter forcedRenewRateLimiter) {
        this.instanceName = new CloudSqlInstanceName(connectionName);
        this.instanceDataSupplier = instanceDataSupplier;
        this.authType = authType;
        this.executor = executor;
        this.keyPair = keyPair;
        this.forcedRenewRateLimiter = forcedRenewRateLimiter;
        this.accessTokenSupplier = authType == AuthType.IAM ? new DefaultAccessTokenSupplier(tokenSourceFactory) : Optional::empty;
        Object object = this.instanceDataGuard;
        synchronized (object) {
            this.currentInstanceData = this.startRefreshAttempt();
            this.nextInstanceData = this.currentInstanceData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceData getInstanceData(long timeoutMs) {
        ListenableFuture<InstanceData> instanceDataFuture;
        Object object = this.instanceDataGuard;
        synchronized (object) {
            instanceDataFuture = this.currentInstanceData;
        }
        try {
            return (InstanceData)instanceDataFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            Object object2 = this.instanceDataGuard;
            synchronized (object2) {
                if (this.currentRefreshFailure != null) {
                    throw new RuntimeException(String.format("Unable to get valid instance data within %d ms. Last refresh attempt failed:", timeoutMs) + this.currentRefreshFailure.getMessage(), this.currentRefreshFailure);
                }
            }
            throw new RuntimeException(String.format("Unable to get valid instance data within %d ms. No refresh has completed.", timeoutMs), e);
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }

    SSLSocket createSslSocket(long timeoutMs) throws IOException {
        return (SSLSocket)this.getInstanceData(timeoutMs).getSslContext().getSocketFactory().createSocket();
    }

    String getPreferredIp(List<String> preferredTypes, long timeoutMs) {
        Map<String, String> ipAddrs = this.getInstanceData(timeoutMs).getIpAddrs();
        for (String ipType : preferredTypes) {
            String preferredIp = ipAddrs.get(ipType);
            if (preferredIp == null) continue;
            return preferredIp;
        }
        throw new IllegalArgumentException(String.format("[%s] Cloud SQL instance  does not have any IP addresses matching preferences (%s)", this.instanceName.getConnectionName(), String.join((CharSequence)", ", preferredTypes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRefresh() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            if (this.refreshRunning) {
                return;
            }
            this.nextInstanceData.cancel(false);
            logger.fine(String.format("[%s] Force Refresh: the next refresh operation was cancelled. Scheduling new refresh operation immediately.", this.instanceName));
            this.nextInstanceData = this.startRefreshAttempt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<InstanceData> startRefreshAttempt() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            this.refreshRunning = true;
        }
        ListenableFuture rateLimit = this.executor.submit(() -> {
            logger.fine(String.format("[%s] Refresh Operation: Acquiring rate limiter permit.", this.instanceName));
            this.forcedRenewRateLimiter.acquire();
            logger.fine(String.format("[%s] Refresh Operation: Acquired rate limiter permit. Starting refresh...", this.instanceName));
        }, (Object)this.executor);
        ListenableFuture dataFuture = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{rateLimit}).callAsync(() -> this.instanceDataSupplier.getInstanceData(this.instanceName, this.accessTokenSupplier, this.authType, this.executor, this.keyPair), (Executor)this.executor);
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{dataFuture}).callAsync(() -> this.handleRefreshResult((ListenableFuture<InstanceData>)dataFuture), (Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<InstanceData> handleRefreshResult(ListenableFuture<InstanceData> dataFuture) {
        try {
            InstanceData data = (InstanceData)dataFuture.get();
            logger.fine(String.format("[%s] Refresh Operation: Completed refresh with new certificate expiration at %s.", this.instanceName, data.getExpiration().toString()));
            long secondsToRefresh = this.refreshCalculator.calculateSecondsUntilNextRefresh(Instant.now(), data.getExpiration());
            logger.fine(String.format("[%s] Refresh Operation: Next operation scheduled at %s.", this.instanceName, Instant.now().plus(secondsToRefresh, ChronoUnit.SECONDS).truncatedTo(ChronoUnit.SECONDS).toString()));
            Object object = this.instanceDataGuard;
            synchronized (object) {
                this.refreshRunning = false;
                this.currentRefreshFailure = null;
                this.currentInstanceData = Futures.immediateFuture((Object)data);
                this.nextInstanceData = Futures.scheduleAsync(this::startRefreshAttempt, (long)secondsToRefresh, (TimeUnit)TimeUnit.SECONDS, (ScheduledExecutorService)this.executor);
                return this.currentInstanceData;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.FINE, String.format("[%s] Refresh Operation: Failed! Starting next refresh operation immediately.", this.instanceName), e);
            Object object = this.instanceDataGuard;
            synchronized (object) {
                this.currentRefreshFailure = e;
                this.nextInstanceData = this.startRefreshAttempt();
                return this.nextInstanceData;
            }
        }
    }

    SslData getSslData(long timeoutMs) {
        return this.getInstanceData(timeoutMs).getSslData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<InstanceData> getNext() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            return this.nextInstanceData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<InstanceData> getCurrent() {
        Object object = this.instanceDataGuard;
        synchronized (object) {
            return this.currentInstanceData;
        }
    }

    public CloudSqlInstanceName getInstanceName() {
        return this.instanceName;
    }
}

