/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.sql.AuthType;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.ApiFetcherFactory;
import com.google.cloud.sql.core.CloudSqlInstance;
import com.google.cloud.sql.core.CredentialFactoryProvider;
import com.google.cloud.sql.core.ServiceAccountImpersonatingCredentialFactory;
import com.google.cloud.sql.core.SqlAdminApiFetcher;
import com.google.cloud.sql.core.SqlAdminApiFetcherFactory;
import com.google.cloud.sql.core.SslData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public final class CoreSocketFactory {
    public static final String CLOUD_SQL_INSTANCE_PROPERTY = "cloudSqlInstance";
    public static final String CLOUD_SQL_DELEGATES_PROPERTY = "cloudSqlDelegates";
    public static final String CLOUD_SQL_TARGET_PRINCIPAL_PROPERTY = "cloudSqlTargetPrincipal";
    @Deprecated
    public static final String USER_TOKEN_PROPERTY_NAME = "_CLOUD_SQL_USER_TOKEN";
    static final long DEFAULT_MAX_REFRESH_MS = 30000L;
    public static final String DEFAULT_IP_TYPES = "PUBLIC,PRIVATE";
    private static final String UNIX_SOCKET_PROPERTY = "unixSocketPath";
    private static final Logger logger = Logger.getLogger(CoreSocketFactory.class.getName());
    private static final int DEFAULT_SERVER_PROXY_PORT = 3307;
    private static final int RSA_KEY_SIZE = 2048;
    private static final List<String> userAgents = new ArrayList<String>();
    private static final String version = CoreSocketFactory.getVersion();
    private static CoreSocketFactory coreSocketFactory;
    private final ListenableFuture<KeyPair> localKeyPair;
    private final ConcurrentHashMap<String, CloudSqlInstance> instances = new ConcurrentHashMap();
    private final ListeningScheduledExecutorService executor;
    private final CredentialFactory credentialFactory;
    private final int serverProxyPort;
    private final long refreshTimeoutMs;
    private final ApiFetcherFactory apiFetcherFactory;

    @VisibleForTesting
    CoreSocketFactory(ListenableFuture<KeyPair> localKeyPair, ApiFetcherFactory apiFetcherFactory, CredentialFactory credentialFactory, int serverProxyPort, long refreshTimeoutMs, ListeningScheduledExecutorService executor) {
        this.apiFetcherFactory = apiFetcherFactory;
        this.credentialFactory = credentialFactory;
        this.serverProxyPort = serverProxyPort;
        this.executor = executor;
        this.localKeyPair = localKeyPair;
        this.refreshTimeoutMs = refreshTimeoutMs;
    }

    public static synchronized CoreSocketFactory getInstance() {
        if (coreSocketFactory == null) {
            logger.info("First Cloud SQL connection, generating RSA key pair.");
            CredentialFactory credentialFactory = CredentialFactoryProvider.getCredentialFactory();
            ListeningScheduledExecutorService executor = CoreSocketFactory.getDefaultExecutor();
            coreSocketFactory = new CoreSocketFactory((ListenableFuture<KeyPair>)executor.submit(CoreSocketFactory::generateRsaKeyPair), new SqlAdminApiFetcherFactory(CoreSocketFactory.getUserAgents()), credentialFactory, 3307, 30000L, executor);
        }
        return coreSocketFactory;
    }

    @VisibleForTesting
    static ListeningScheduledExecutorService getDefaultExecutor() {
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(8);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor));
    }

    private static String getUnixSocketArg(Properties props) {
        String unixSocketPath = props.getProperty(UNIX_SOCKET_PROPERTY);
        if (unixSocketPath != null) {
            return unixSocketPath;
        }
        if (System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null) {
            logger.warning(String.format("\"CLOUD_SQL_FORCE_UNIX_SOCKET\" env var has been deprecated. Please use '%s=\"/cloudsql/INSTANCE_CONNECTION_NAME\"' property in your JDBC url instead.", UNIX_SOCKET_PROPERTY));
            return "/cloudsql/" + props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        }
        return null;
    }

    public static Socket connect(Properties props) throws IOException, InterruptedException {
        return CoreSocketFactory.connect(props, null);
    }

    public static Socket connect(Properties props, String unixPathSuffix) throws IOException, InterruptedException {
        String csqlInstanceName = props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        boolean enableIamAuth = Boolean.parseBoolean(props.getProperty("enableIamAuth"));
        String targetPrincipal = props.getProperty(CLOUD_SQL_TARGET_PRINCIPAL_PROPERTY);
        String delegatesStr = props.getProperty(CLOUD_SQL_DELEGATES_PROPERTY);
        List<String> delegates = delegatesStr != null && !delegatesStr.isEmpty() ? Arrays.asList(delegatesStr.split(",")) : Collections.emptyList();
        Preconditions.checkArgument((csqlInstanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        String unixSocket = CoreSocketFactory.getUnixSocketArg(props);
        if (unixSocket != null) {
            if (unixPathSuffix != null && !unixSocket.endsWith(unixPathSuffix)) {
                unixSocket = unixSocket + unixPathSuffix;
            }
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket at %s.", csqlInstanceName, unixSocket));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(unixSocket));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        List<String> ipTypes = CoreSocketFactory.listIpTypes(props.getProperty("ipTypes", DEFAULT_IP_TYPES));
        if (enableIamAuth) {
            return CoreSocketFactory.getInstance().createSslSocket(csqlInstanceName, ipTypes, AuthType.IAM, targetPrincipal, delegates);
        }
        return CoreSocketFactory.getInstance().createSslSocket(csqlInstanceName, ipTypes, AuthType.PASSWORD, targetPrincipal, delegates);
    }

    public static SslData getSslData(String csqlInstanceName, boolean enableIamAuth, String targetPrincipal, List<String> delegates) throws IOException {
        if (enableIamAuth) {
            CoreSocketFactory factory = CoreSocketFactory.getInstance();
            return factory.getCloudSqlInstance(csqlInstanceName, AuthType.IAM, targetPrincipal, delegates).getSslData(factory.refreshTimeoutMs);
        }
        CoreSocketFactory factory = CoreSocketFactory.getInstance();
        return factory.getCloudSqlInstance(csqlInstanceName, AuthType.PASSWORD, targetPrincipal, delegates).getSslData(factory.refreshTimeoutMs);
    }

    public static String getHostIp(String csqlInstanceName, String ipTypes, String targetPrincipal, List<String> delegates) throws IOException {
        return CoreSocketFactory.getInstance().getHostIp(csqlInstanceName, CoreSocketFactory.listIpTypes(ipTypes), targetPrincipal, delegates);
    }

    private String getHostIp(String instanceName, List<String> ipTypes, String targetPrincipal, List<String> delegates) {
        CloudSqlInstance instance = this.getCloudSqlInstance(instanceName, AuthType.PASSWORD, targetPrincipal, delegates);
        return instance.getPreferredIp(ipTypes, this.refreshTimeoutMs);
    }

    private static List<String> listIpTypes(String cloudSqlIpTypes) {
        List rawTypes = Splitter.on((char)',').splitToList((CharSequence)cloudSqlIpTypes);
        ArrayList<String> result = new ArrayList<String>(rawTypes.size());
        for (String type : rawTypes) {
            if (type.trim().equalsIgnoreCase("PUBLIC")) {
                result.add("PRIMARY");
                continue;
            }
            result.add(type.trim().toUpperCase());
        }
        return result;
    }

    private static KeyPair generateRsaKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException("Unable to initialize Cloud SQL socket factory because no RSA implementation is available.");
        }
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    private static String getVersion() {
        try {
            Properties packageInfo = new Properties();
            packageInfo.load(CoreSocketFactory.class.getClassLoader().getResourceAsStream("com.google.cloud.sql/project.properties"));
            return packageInfo.getProperty("version", "unknown");
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    public static void addArtifactId(String artifactId) {
        String userAgent = artifactId + "/" + version;
        if (!userAgents.contains(userAgent)) {
            userAgents.add(userAgent);
        }
    }

    @VisibleForTesting
    static void resetUserAgent() {
        coreSocketFactory = null;
        userAgents.clear();
        CoreSocketFactory.setApplicationName("");
    }

    static String getUserAgents() {
        String ua = String.join((CharSequence)" ", userAgents);
        String appName = CoreSocketFactory.getApplicationName();
        if (!Strings.isNullOrEmpty((String)appName)) {
            ua = ua + " " + appName;
        }
        return ua;
    }

    private static String getApplicationName() {
        return System.getProperty(USER_TOKEN_PROPERTY_NAME, "");
    }

    public static void setApplicationName(String applicationName) {
        if (coreSocketFactory != null) {
            throw new IllegalStateException("Unable to set ApplicationName - SQLAdmin client already initialized.");
        }
        System.setProperty(USER_TOKEN_PROPERTY_NAME, applicationName);
    }

    @VisibleForTesting
    Socket createSslSocket(String instanceName, List<String> ipTypes, AuthType authType, String targetPrincipal, List<String> delegates) throws IOException, InterruptedException {
        CloudSqlInstance instance = this.getCloudSqlInstance(instanceName, authType, targetPrincipal, delegates);
        try {
            SSLSocket socket = instance.createSslSocket(this.refreshTimeoutMs);
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            String instanceIp = instance.getPreferredIp(ipTypes, this.refreshTimeoutMs);
            socket.connect(new InetSocketAddress(instanceIp, this.serverProxyPort));
            socket.startHandshake();
            return socket;
        }
        catch (Exception ex) {
            instance.forceRefresh();
            throw ex;
        }
    }

    CloudSqlInstance getCloudSqlInstance(String instanceName, AuthType authType, String targetPrincipal, List<String> delegates) {
        return this.instances.computeIfAbsent(instanceName, k -> this.apiFetcher((String)k, authType, targetPrincipal, delegates));
    }

    private CloudSqlInstance apiFetcher(String instanceName, AuthType authType, String targetPrincipal, List<String> delegates) {
        CredentialFactory instanceCredentialFactory;
        if (targetPrincipal != null && !targetPrincipal.isEmpty()) {
            instanceCredentialFactory = new ServiceAccountImpersonatingCredentialFactory(this.credentialFactory, targetPrincipal, delegates);
        } else {
            if (delegates != null && !delegates.isEmpty()) {
                throw new IllegalArgumentException(String.format("Connection property %s must be when %s is set.", CLOUD_SQL_TARGET_PRINCIPAL_PROPERTY, CLOUD_SQL_DELEGATES_PROPERTY));
            }
            instanceCredentialFactory = this.credentialFactory;
        }
        HttpRequestInitializer credential = instanceCredentialFactory.create();
        SqlAdminApiFetcher adminApi = this.apiFetcherFactory.create(credential);
        return new CloudSqlInstance(instanceName, adminApi, authType, instanceCredentialFactory, this.executor, this.localKeyPair, RateLimiter.create((double)0.03333333333333333));
    }
}

