/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.Metadata;
import com.google.cloud.sql.core.SslData;
import java.time.Instant;
import java.util.Map;
import javax.net.ssl.SSLContext;

class InstanceData {
    private final Metadata metadata;
    private final SSLContext sslContext;
    private final SslData sslData;
    private final Instant expiration;

    InstanceData(Metadata metadata, SslData sslData, Instant expiration) {
        this.metadata = metadata;
        this.sslData = sslData;
        this.sslContext = sslData.getSslContext();
        this.expiration = expiration;
    }

    Instant getExpiration() {
        return this.expiration;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    Map<String, String> getIpAddrs() {
        return this.metadata.getIpAddrs();
    }

    SslData getSslData() {
        return this.sslData;
    }
}

